/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractDataReader;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.StrictDecimalFormat;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.io.Encoding;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class ArffExampleSource
extends AbstractDataReader {
    public static final String PARAMETER_DATA_FILE = "data_file";

    public ArffExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    protected AbstractDataReader.DataSet getDataSet() throws OperatorException, IOException {
        return new AbstractDataReader.DataSet(){
            private InputStream inputStream = null;
            private BufferedReader in = null;
            private StreamTokenizer tokenizer = null;
            private NumberFormat numberFormat = StrictDecimalFormat.getInstance(ArffExampleSource.this);
            private DateFormat dateFormat = new SimpleDateFormat();
            private String[] tokens = null;
            {
                this.inputStream = ArffExampleSource.this.getParameterAsInputStream(ArffExampleSource.PARAMETER_DATA_FILE);
                this.in = new BufferedReader(new InputStreamReader(this.inputStream, Encoding.getEncoding(ArffExampleSource.this)));
                this.tokenizer = ArffExampleSource.this.createTokenizer(this.in);
                Tools.getFirstToken(this.tokenizer);
                if (this.tokenizer.ttype == -1) {
                    throw new UserError((Operator)ArffExampleSource.this, 302, ArffExampleSource.this.getParameterAsString(ArffExampleSource.PARAMETER_DATA_FILE), "file is empty");
                }
                if (!"@relation".equalsIgnoreCase(this.tokenizer.sval)) {
                    throw new IOException("expected the keyword @relation in line " + this.tokenizer.lineno());
                }
                Tools.getNextToken(this.tokenizer);
                Tools.getLastToken(this.tokenizer, false);
                Tools.getFirstToken(this.tokenizer);
                if (this.tokenizer.ttype == -1) {
                    throw new IOException("unexpected end of file in line " + this.tokenizer.lineno() + ", attribute description expected...");
                }
                LinkedList<String> attributeNamesList = new LinkedList<String>();
                LinkedList<Integer> valueTypesList = new LinkedList<Integer>();
                LinkedList valueSets = new LinkedList();
                LinkedHashSet<String> valueSet = null;
                while ("@attribute".equalsIgnoreCase(this.tokenizer.sval)) {
                    Tools.getNextToken(this.tokenizer);
                    String attributeName = this.tokenizer.sval;
                    attributeNamesList.add(attributeName);
                    Tools.getNextToken(this.tokenizer);
                    int valueType = 0;
                    if (this.tokenizer.ttype == -3) {
                        if (this.tokenizer.sval.equalsIgnoreCase("real")) {
                            valueType = 4;
                        } else if (this.tokenizer.sval.equalsIgnoreCase("integer")) {
                            valueType = 3;
                        } else if (this.tokenizer.sval.equalsIgnoreCase("numeric")) {
                            valueType = 2;
                        } else if (this.tokenizer.sval.equalsIgnoreCase("string")) {
                            valueType = 5;
                        } else if (this.tokenizer.sval.equalsIgnoreCase("date")) {
                            valueType = 10;
                        }
                        Tools.waitForEOL(this.tokenizer);
                        valueSet = null;
                    } else {
                        valueType = 1;
                        this.tokenizer.pushBack();
                        valueSet = new LinkedHashSet<String>();
                        if (this.tokenizer.nextToken() != 123) {
                            throw new IOException("{ expected at beginning of nominal values definition in line " + this.tokenizer.lineno());
                        }
                        while (this.tokenizer.nextToken() != 125) {
                            if (this.tokenizer.ttype == 10) {
                                throw new IOException("} expected at end of the nominal values definition in line " + this.tokenizer.lineno());
                            }
                            valueSet.add(this.tokenizer.sval);
                        }
                        if (valueSet.size() == 0) {
                            throw new IOException("empty definition of nominal values is not suggested in line " + this.tokenizer.lineno());
                        }
                    }
                    valueTypesList.add(valueType);
                    valueSets.add(valueSet);
                    Tools.getLastToken(this.tokenizer, false);
                    Tools.getFirstToken(this.tokenizer);
                    if (this.tokenizer.ttype != -1) continue;
                    throw new IOException("unexpected end of file before data section in line " + this.tokenizer.lineno());
                }
                String[] attributeNames = new String[attributeNamesList.size()];
                attributeNames = attributeNamesList.toArray(attributeNames);
                ArffExampleSource.this.setAttributeNames(attributeNames);
                ArffExampleSource.this.setValueTypes(valueTypesList);
                if (!"@data".equalsIgnoreCase(this.tokenizer.sval)) {
                    throw new IOException("expected keyword '@data' in line " + this.tokenizer.lineno());
                }
                if (attributeNamesList.size() == 0) {
                    throw new IOException("no attributes were declared in the ARFF file, please declare attributes with the '@attribute' keyword.");
                }
            }

            @Override
            public boolean next() {
                try {
                    Tools.getFirstToken(this.tokenizer);
                }
                catch (IOException e) {
                    return false;
                }
                if (this.tokenizer.ttype == -1) {
                    return false;
                }
                try {
                    this.tokens = new String[ArffExampleSource.this.getColumnCount()];
                    if (this.tokenizer.ttype == 123) {
                        for (int t = 0; t < this.tokens.length; ++t) {
                            this.tokens[t] = "0";
                        }
                        while (true) {
                            if (this.tokenizer.nextToken() == 10) {
                                throw new IOException("unexpedted end of line " + this.tokenizer.lineno());
                            }
                            if (this.tokenizer.ttype == -1) {
                                throw new IOException("unexpedted end of file in line " + this.tokenizer.lineno());
                            }
                            if (this.tokenizer.ttype == 125) break;
                            int index = Integer.valueOf(this.tokenizer.sval);
                            Tools.getNextToken(this.tokenizer);
                            if (this.tokenizer.ttype == 63) {
                                this.tokens[index] = null;
                                continue;
                            }
                            if (this.tokenizer.ttype != -3) {
                                throw new IOException("not a valid value '" + this.tokenizer.sval + "' in line " + this.tokenizer.lineno());
                            }
                            this.tokens[index] = this.tokenizer.sval;
                        }
                        Tools.getLastToken(this.tokenizer, true);
                    } else {
                        for (int i = 0; i < ArffExampleSource.this.getColumnCount(); ++i) {
                            if (i > 0) {
                                Tools.getNextToken(this.tokenizer);
                            }
                            if (this.tokenizer.ttype == 63) {
                                this.tokens[i] = null;
                                continue;
                            }
                            if (this.tokenizer.ttype != -3) {
                                throw new IOException("not a valid value '" + this.tokenizer.sval + "' in line " + this.tokenizer.lineno());
                            }
                            this.tokens[i] = this.tokenizer.sval;
                        }
                        Tools.getLastToken(this.tokenizer, true);
                    }
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public void close() {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public int getNumberOfColumnsInCurrentRow() {
                return this.tokens.length;
            }

            @Override
            public boolean isMissing(int columnIndex) {
                return this.tokens[columnIndex] == null || this.tokens[columnIndex].isEmpty();
            }

            @Override
            public Number getNumber(int columnIndex) {
                try {
                    return this.numberFormat.parse(this.tokens[columnIndex]);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }

            @Override
            public String getString(int columnIndex) {
                return this.tokens[columnIndex];
            }

            @Override
            public Date getDate(int columnIndex) {
                try {
                    return this.dateFormat.parse(this.tokens[columnIndex]);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
        };
    }

    private StreamTokenizer createTokenizer(Reader in) {
        StreamTokenizer tokenizer = new StreamTokenizer(in);
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.wordChars(33, 255);
        tokenizer.whitespaceChars(44, 44);
        tokenizer.commentChar(37);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.ordinaryChar(123);
        tokenizer.ordinaryChar(125);
        tokenizer.eolIsSignificant(true);
        return tokenizer;
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_DATA_FILE, "The path to the data file.", "arff", false));
        types.addAll(super.getParameterTypes());
        types.addAll(StrictDecimalFormat.getParameterTypes(this));
        return types;
    }

    static {
        AbstractReader.registerReaderDescription(new AbstractReader.ReaderDescription("arff", ArffExampleSource.class, PARAMETER_DATA_FILE));
    }
}

