/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ArffExampleSetWriter
extends AbstractExampleSetWriter {
    public static final String PARAMETER_EXAMPLE_SET_FILE = "example_set_file";

    public ArffExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet exampleSet) throws OperatorException {
        try {
            File arffFile = this.getParameterAsFile(PARAMETER_EXAMPLE_SET_FILE, true);
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(arffFile), Encoding.getEncoding(this)));
            ArffExampleSetWriter.writeArff(exampleSet, out);
            out.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, this.getParameterAsString(PARAMETER_EXAMPLE_SET_FILE), e.getMessage());
        }
        return exampleSet;
    }

    public static void writeArff(ExampleSet exampleSet, PrintWriter out) {
        out.println("@RELATION RapidMinerData");
        out.println();
        Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
        while (a.hasNext()) {
            ArffExampleSetWriter.printAttributeData(a.next(), out);
        }
        out.println();
        out.println("@DATA");
        for (Example example : exampleSet) {
            boolean first = true;
            a = exampleSet.getAttributes().allAttributes();
            while (a.hasNext()) {
                Attribute current = a.next();
                if (!first) {
                    out.print(",");
                }
                if (current.isNominal()) {
                    double value = example.getValue(current);
                    if (Double.isNaN(value)) {
                        out.print("?");
                    } else {
                        out.print("'" + example.getValueAsString(current) + "'");
                    }
                } else {
                    out.print(example.getValueAsString(current));
                }
                first = false;
            }
            out.println();
        }
    }

    private static void printAttributeData(Attribute attribute, PrintWriter out) {
        out.print("@ATTRIBUTE '" + attribute.getName() + "' ");
        if (attribute.isNominal()) {
            StringBuffer nominalValues = new StringBuffer("{");
            boolean first = true;
            for (String s : attribute.getMapping().getValues()) {
                if (!first) {
                    nominalValues.append(",");
                }
                nominalValues.append("'" + s + "'");
                first = false;
            }
            nominalValues.append("}");
            out.print(nominalValues.toString());
        } else {
            out.print("real");
        }
        out.println();
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_EXAMPLE_SET_FILE, "File to save the example set to.", "arff", false));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

