/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import java.io.File;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class AccessDataWriter
extends AbstractExampleSetWriter {
    public static final String PARAMETER_DATABASE_FILE = "database_file";
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_TABLE_NAME = "table_name";
    public static final String PARAMETER_OVERWRITE_MODE = "overwrite_mode";

    public AccessDataWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet exampleSet) throws OperatorException {
        String password;
        File databaseFile = this.getParameterAsFile(PARAMETER_DATABASE_FILE);
        String databaseURL = "jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=" + databaseFile.getAbsolutePath();
        String username = this.getParameterAsString(PARAMETER_USERNAME);
        if (username == null) {
            username = "noUser";
        }
        if ((password = this.getParameterAsString(PARAMETER_PASSWORD)) == null) {
            password = "noPassword";
        }
        DatabaseHandler handler = null;
        try {
            handler = DatabaseHandler.getConnectedDatabaseHandler(databaseURL, username, password);
            handler.createTable(exampleSet, this.getParameterAsString(PARAMETER_TABLE_NAME), this.getParameterAsInt(PARAMETER_OVERWRITE_MODE), this.getApplyCount() == 0, -1);
            handler.disconnect();
            return exampleSet;
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, e.getMessage());
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_DATABASE_FILE, "The mdb file containing the Access database which should be written to.", "mdb", false, false));
        types.add(new ParameterTypeString(PARAMETER_USERNAME, "The username for the Access database.", true, false));
        ParameterTypePassword type = new ParameterTypePassword(PARAMETER_PASSWORD, "The password for the database.");
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_TABLE_NAME, "The name of the table within the Access database to which the data set should be written.", false, false));
        types.add(new ParameterTypeCategory(PARAMETER_OVERWRITE_MODE, "Indicates if an existing table should be overwritten or if data should be appended.", DatabaseHandler.OVERWRITE_MODES, 0));
        return types;
    }
}

