/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.DatabaseDataReader;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDatabaseTable;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeSQLQuery;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.connection.AccessConnectionEntry;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import java.io.File;
import java.sql.ResultSet;
import java.util.List;

public class AccessDataReader
extends DatabaseDataReader {
    public static final String PARAMETER_DATABASE_FILE = "database_file";
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";
    private static final String DATABASE_URL_PREFIX = "jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=";
    private static final String DEFAULT_USER_NAME = "noUser";
    private static final String DEFAULT_PASSWORD = "noPassword";

    public AccessDataReader(OperatorDescription description) throws OperatorCreationException {
        super(description);
        this.setParameter("define_connection", DatabaseHandler.CONNECTION_MODES[1]);
        this.setParameter("database_system", "ODBC Bridge (e.g. Access)");
        this.setParameter(PARAMETER_USERNAME, DEFAULT_USER_NAME);
        this.setParameter(PARAMETER_PASSWORD, DEFAULT_PASSWORD);
        this.getParameters().addObserver(new Observer<String>(){

            @Override
            public void update(Observable<String> observable, String arg) {
                if (arg == null || !arg.equals(AccessDataReader.PARAMETER_DATABASE_FILE)) {
                    return;
                }
                if (AccessDataReader.this.getParameters().getParameterOrNull(AccessDataReader.PARAMETER_DATABASE_FILE) == null) {
                    return;
                }
                try {
                    String path = AccessDataReader.this.getParameterAsFile(AccessDataReader.PARAMETER_DATABASE_FILE).getAbsolutePath();
                    AccessDataReader.this.setParameter("database_url", AccessDataReader.DATABASE_URL_PREFIX + path);
                }
                catch (UndefinedParameterError e) {
                    // empty catch block
                }
            }
        }, false);
    }

    @Override
    protected ResultSet getResultSet() throws OperatorException {
        this.setAccessParameters();
        return super.getResultSet();
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        this.setAccessParameters();
        return super.getGeneratedMetaData();
    }

    protected void setAccessParameters() throws UndefinedParameterError {
        String password;
        File databaseFile = this.getParameterAsFile(PARAMETER_DATABASE_FILE);
        this.setParameter("database_url", DATABASE_URL_PREFIX + databaseFile.getAbsolutePath());
        String userName = this.getParameterAsString(PARAMETER_USERNAME);
        if (userName == null) {
            userName = DEFAULT_USER_NAME;
        }
        if ((password = this.getParameterAsString(PARAMETER_PASSWORD)) == null) {
            password = DEFAULT_PASSWORD;
        }
        this.setParameter(PARAMETER_USERNAME, userName);
        this.setParameter(PARAMETER_PASSWORD, password);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        for (ParameterType t : types) {
            t.setHidden(true);
        }
        types.add(new ParameterTypeFile(PARAMETER_DATABASE_FILE, "The mdb file containing the Access database which should be read from.", "mdb", false, false));
        types.add(new ParameterTypeString(PARAMETER_USERNAME, "The username for the Access database.", true, false));
        ParameterTypeSingle type = new ParameterTypePassword(PARAMETER_PASSWORD, "The password for the Access database.");
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("define_query", "Specifies whether the database query should be defined directly, through a file or implicitely by a given table name.", DatabaseHandler.QUERY_MODES, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeSQLQuery("query", "An SQL query.");
        type.registerDependencyCondition(new EqualTypeCondition(this, "define_query", DatabaseHandler.QUERY_MODES, true, 0));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeFile("query_file", "A file containing an SQL query.", null, true);
        type.registerDependencyCondition(new EqualTypeCondition(this, "define_query", DatabaseHandler.QUERY_MODES, true, 1));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDatabaseTable("table_name", "The name of a single table within the Access database which should be read.");
        type.registerDependencyCondition(new EqualTypeCondition(this, "define_query", DatabaseHandler.QUERY_MODES, true, 2));
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public ConnectionEntry getConnectionEntry() {
        try {
            File file = this.getParameterAsFile(PARAMETER_DATABASE_FILE);
            if (file != null) {
                return new AccessConnectionEntry(file);
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return null;
    }
}

