/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.Process;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.io.Encoding;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractReader<T extends IOObject>
extends Operator {
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("output");
    private final Class<? extends IOObject> generatedClass;
    private boolean cacheDirty = true;
    private MetaData cachedMetaData;
    private MetaDataError cachedError;
    private static final Map<String, ReaderDescription> READER_DESCRIPTIONS = new HashMap<String, ReaderDescription>();

    public AbstractReader(OperatorDescription description, Class<? extends IOObject> generatedClass) {
        super(description);
        this.generatedClass = generatedClass;
        this.getTransformer().addRule(new MDTransformationRule(){

            @Override
            public void transformMD() {
                if (AbstractReader.this.cacheDirty || !AbstractReader.this.isMetaDataCacheable()) {
                    try {
                        AbstractReader.this.cachedMetaData = AbstractReader.this.getGeneratedMetaData();
                        AbstractReader.this.cachedError = null;
                    }
                    catch (OperatorException e) {
                        AbstractReader.this.cachedMetaData = new MetaData(AbstractReader.this.generatedClass);
                        String msg = e.getMessage();
                        if (msg == null || msg.length() == 0) {
                            msg = e.toString();
                        }
                        AbstractReader.this.cachedError = new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)AbstractReader.this.outputPort, "cannot_create_exampleset_metadata", msg);
                    }
                    if (AbstractReader.this.cachedMetaData != null) {
                        AbstractReader.this.cachedMetaData.addToHistory(AbstractReader.this.outputPort);
                    }
                    AbstractReader.this.cacheDirty = false;
                }
                AbstractReader.this.outputPort.deliverMD(AbstractReader.this.cachedMetaData);
                if (AbstractReader.this.cachedError != null) {
                    AbstractReader.this.outputPort.addError(AbstractReader.this.cachedError);
                }
            }
        });
        this.observeParameters();
    }

    private void observeParameters() {
        this.getParameters().addObserverAsFirst(new Observer<String>(){

            @Override
            public void update(Observable<String> observable, String arg) {
                AbstractReader.this.cacheDirty = true;
            }
        }, false);
    }

    public MetaData getGeneratedMetaData() throws OperatorException {
        return new MetaData(this.generatedClass);
    }

    protected boolean isMetaDataCacheable() {
        return false;
    }

    public abstract T read() throws OperatorException;

    @Override
    public void doWork() throws OperatorException {
        T result = this.read();
        this.addAnnotations(result);
        this.outputPort.deliver((IOObject)result);
    }

    protected void addAnnotations(T result) {
        for (ReaderDescription rd : READER_DESCRIPTIONS.values()) {
            if (!rd.readerClass.equals(this.getClass())) continue;
            try {
                result.getAnnotations().setAnnotation("Source", this.getParameter(rd.fileParameterKey));
            }
            catch (UndefinedParameterError e) {
                // empty catch block
            }
            return;
        }
    }

    protected static void registerReaderDescription(ReaderDescription rd) {
        READER_DESCRIPTIONS.put(rd.fileExtension.toLowerCase(), rd);
    }

    public static AbstractReader createReader(URL url) throws OperatorCreationException {
        String file = url.getFile();
        int dot = file.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        String extension = file.substring(dot + 1).toLowerCase();
        ReaderDescription rd = READER_DESCRIPTIONS.get(extension);
        if (rd == null) {
            return null;
        }
        AbstractReader reader = (AbstractReader)OperatorService.createOperator(rd.readerClass);
        reader.setParameter(rd.fileParameterKey, url.toString());
        return reader;
    }

    public static boolean canMakeReaderFor(URL url) {
        String file = url.getFile();
        int dot = file.lastIndexOf(46);
        if (dot == -1) {
            return false;
        }
        String extension = file.substring(dot + 1).toLowerCase();
        return READER_DESCRIPTIONS.containsKey(extension);
    }

    public static String getFileParameterForOperator(Operator operator) {
        for (ReaderDescription rd : READER_DESCRIPTIONS.values()) {
            if (!rd.readerClass.equals(operator.getClass())) continue;
            return rd.fileParameterKey;
        }
        return null;
    }

    @Override
    protected void registerOperator(Process process) {
        super.registerOperator(process);
        this.cacheDirty = true;
    }

    protected boolean supportsEncoding() {
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        if (this.supportsEncoding()) {
            types.addAll(Encoding.getParameterTypes(this));
        }
        return types;
    }

    public static class ReaderDescription {
        private final String fileExtension;
        private final Class<? extends AbstractReader> readerClass;
        private final String fileParameterKey;

        public ReaderDescription(String fileExtension, Class<? extends AbstractReader> readerClass, String fileParameterKey) {
            this.fileExtension = fileExtension;
            this.readerClass = readerClass;
            this.fileParameterKey = fileParameterKey;
        }
    }
}

