/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeTypeException;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.io.CSVDataReader;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.container.Range;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class AbstractDataReader
extends AbstractExampleSource {
    public static final int PREVIEW_LINES = 300;
    public static final String PARAMETER_ERROR_TOLERANT = "read_not_matching_values_as_missings";
    private static final String PARAMETER_ATTRIBUTE_NAMES_DEFINED_BY_USER = "attribute_names_already_defined";
    private static final String PARAMETER_META_DATA = "data_set_meta_data_information";
    public static final String PARAMETER_COLUMN_INDEX = "column_index";
    public static final String PARAMETER_COLUMN_META_DATA = "attribute_meta_data_information";
    public static final String PARAMETER_COLUMN_NAME = "attribute name";
    public static final String PARAMETER_COLUMN_SELECTED = "column_selected";
    public static final String PARAMETER_COLUM_VALUE_TYPE = "attribute_value_type";
    public static final String PARAMETER_COLUM_ROLE = "attribute_role";
    public static final ArrayList<String> ROLE_NAMES = new ArrayList();
    private List<OperatorException> importErrors;
    private int rowCountFromGuessing;
    private boolean metaDataFixed;
    private boolean guessedValueTypes;
    private boolean detectErrorsInPreview;
    boolean isErrorTollerantCache;
    private boolean stopReading;
    TreeMap<Integer, TreeSet<Integer>> errorCells;
    private List<AttributeColumn> attributeColumns;

    protected abstract DataSet getDataSet() throws OperatorException, IOException;

    public void clearAllReaderSettings() {
        this.clearReaderSettings();
        this.deleteAttributeMetaDataParamters();
    }

    public void clearReaderSettings() {
        this.stopReading();
        this.attributeColumns.clear();
        this.importErrors.clear();
    }

    public void deleteAttributeMetaDataParamters() {
        this.setParameter(PARAMETER_META_DATA, null);
        this.setAttributeNamesDefinedByUser(false);
    }

    public AbstractDataReader(OperatorDescription description) {
        super(description);
        ROLE_NAMES.clear();
        for (int i = 0; i < Attributes.KNOWN_ATTRIBUTE_TYPES.length; ++i) {
            if (Attributes.KNOWN_ATTRIBUTE_TYPES[i].equals("attribute")) {
                ROLE_NAMES.add("regular");
                continue;
            }
            ROLE_NAMES.add(Attributes.KNOWN_ATTRIBUTE_TYPES[i]);
        }
        this.importErrors = new LinkedList<OperatorException>();
        this.rowCountFromGuessing = 0;
        this.metaDataFixed = false;
        this.guessedValueTypes = false;
        this.detectErrorsInPreview = false;
        this.isErrorTollerantCache = true;
        this.stopReading = false;
        this.errorCells = new TreeMap();
        this.attributeColumns = new ArrayList<AttributeColumn>();
    }

    public boolean attributeNamesDefinedByUser() {
        return this.getParameterAsBoolean(PARAMETER_ATTRIBUTE_NAMES_DEFINED_BY_USER);
    }

    public void setAttributeNamesDefinedByUser(boolean flag) {
        this.setParameter(PARAMETER_ATTRIBUTE_NAMES_DEFINED_BY_USER, Boolean.toString(flag));
    }

    public List<AttributeColumn> getActiveAttributeColumns() {
        LinkedList<AttributeColumn> list = new LinkedList<AttributeColumn>();
        for (AttributeColumn column : this.attributeColumns) {
            if (!column.isActivated()) continue;
            list.add(column);
        }
        return list;
    }

    public List<AttributeColumn> getAllAttributeColumns() {
        return Collections.unmodifiableList(this.attributeColumns);
    }

    public AttributeColumn getAttributeColumn(int index) throws IllegalArgumentException {
        if (index < this.attributeColumns.size()) {
            return this.attributeColumns.get(index);
        }
        throw new IllegalArgumentException("The attribute column with index " + index + " does not exists.");
    }

    public int getIndexOfAttributeColumn(AttributeColumn column) {
        return this.attributeColumns.indexOf(column);
    }

    public int getIndexOfActiveAttributeColumn(AttributeColumn column) {
        return this.getActiveAttributeColumns().indexOf(column);
    }

    public void addAttributeColumn() {
        String name = this.getNewGenericColumnName(this.attributeColumns.size());
        this.attributeColumns.add(new AttributeColumn(name));
    }

    public void addAttributeColumn(String attributeName) {
        this.attributeColumns.add(new AttributeColumn(attributeName));
    }

    public boolean isMetaDatafixed() {
        return this.metaDataFixed;
    }

    public void fixMetaDataDefinition() {
        this.metaDataFixed = true;
    }

    public void writeMetaDataInParameter() {
        this.deleteAttributeMetaDataParamters();
        this.setAttributeNamesDefinedByUser(true);
        for (AttributeColumn col : this.getAllAttributeColumns()) {
            col.setMetaParameter();
        }
    }

    public void loadMetaDataFromParameters() {
        List<AttributeColumn> oldColumns = this.attributeColumns;
        this.attributeColumns.clear();
        try {
            List<String[]> metaData = this.getParameterList(PARAMETER_META_DATA);
            for (int i = 0; i < metaData.size(); ++i) {
                this.addAttributeColumn();
            }
            Iterator<AttributeColumn> it = oldColumns.iterator();
            for (AttributeColumn column : this.getAllAttributeColumns()) {
                column.loadMetaParameter();
                Annotations ann = it.next().getAnnotations();
                for (String key : ann.getKeys()) {
                    column.getAnnotations().setAnnotation(key, ann.get(key));
                }
            }
        }
        catch (UndefinedParameterError e) {
            e.printStackTrace();
        }
    }

    public int getColumnCount() {
        return this.attributeColumns.size();
    }

    private int getRowCountFromGuessing() {
        return this.rowCountFromGuessing;
    }

    @Override
    public ExampleSetMetaData getGeneratedMetaData() {
        if (this.attributeNamesDefinedByUser()) {
            this.loadMetaDataFromParameters();
            this.guessedValueTypes = true;
        }
        if (!this.guessedValueTypes) {
            return new ExampleSetMetaData();
        }
        ExampleSetMetaData metaData = new ExampleSetMetaData();
        for (AttributeColumn column : this.getActiveAttributeColumns()) {
            AttributeMetaData amd = new AttributeMetaData(column.getName(), column.getValueType());
            amd.setAnnotations(column.getAnnotations());
            String role = column.getRole();
            if (role.equals("regular")) {
                role = null;
            }
            amd.setRole(role);
            MDInteger missings = new MDInteger(column.numberOfMissings);
            SetRelation relation = SetRelation.EQUAL;
            if (!this.isMetaDatafixed()) {
                relation = SetRelation.SUPERSET;
                missings.increaseByUnknownAmount();
            }
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(column.getValueType(), 2) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(column.getValueType(), 9)) {
                amd.setValueRange(new Range(column.maxValue, column.maxValue), relation);
            } else {
                amd.setValueSet(column.valueSet, relation);
            }
            amd.setNumberOfMissingValues(missings);
            metaData.addAttribute(amd);
        }
        metaData.setNumberOfExamples(new MDInteger(this.getRowCountFromGuessing()));
        if (!this.isMetaDatafixed()) {
            metaData.getNumberOfExamples().increaseByUnknownAmount();
            metaData.attributesAreSuperset();
        }
        return metaData;
    }

    private double[] generateRow(DataSet set, List<Attribute> activeAttributes, int rowNumber) throws OperatorException {
        UnexpectedRowLenghtException e;
        List<AttributeColumn> allAttributeColumns = this.getAllAttributeColumns();
        if (allAttributeColumns.size() > set.getNumberOfColumnsInCurrentRow()) {
            e = new TooShortRowLengthException(rowNumber, set.getNumberOfColumnsInCurrentRow(), allAttributeColumns.size());
            if (this.isErrorTolerant()) {
                this.logReadingError(e);
            } else {
                throw e;
            }
        }
        if (allAttributeColumns.size() < set.getNumberOfColumnsInCurrentRow()) {
            e = new TooLongRowLengthException(rowNumber, set.getNumberOfColumnsInCurrentRow(), allAttributeColumns.size());
            if (this.isErrorTolerant()) {
                if (this instanceof CSVDataReader) {
                    this.adjustAttributeColumnsNumbers(set.getNumberOfColumnsInCurrentRow());
                    for (AttributeColumn col : this.getActiveAttributeColumns()) {
                        if (activeAttributes.contains(col.getAttribute())) continue;
                        activeAttributes.add(col.getAttribute());
                    }
                }
                this.logReadingError(e);
            } else {
                throw e;
            }
        }
        double[] values = new double[activeAttributes.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.NaN;
        }
        int activeAttributeIndex = 0;
        for (int columnIndex = 0; columnIndex < set.getNumberOfColumnsInCurrentRow(); ++columnIndex) {
            block24: {
                AttributeColumn column = allAttributeColumns.get(columnIndex);
                if (!column.isActivated()) continue;
                assert (columnIndex != -1);
                try {
                    if (set.isMissing(columnIndex)) {
                        values[activeAttributeIndex] = Double.NaN;
                        break block24;
                    }
                    if (column.getValueType() == 10 || column.getValueType() == 11 || column.getValueType() == 9 || Ontology.ATTRIBUTE_VALUE_TYPE.isA(column.getValueType(), 9)) {
                        Date dateValue = set.getDate(columnIndex);
                        if (dateValue == null) {
                            throw new UnexpectedValueTypeException(9, rowNumber, columnIndex, (Object)set.getString(columnIndex));
                        }
                        values[activeAttributeIndex] = dateValue.getTime();
                        break block24;
                    }
                    if (column.getValueType() == 3 || column.getValueType() == 4 || column.getValueType() == 2 || Ontology.ATTRIBUTE_VALUE_TYPE.isA(column.getValueType(), 2)) {
                        Number numberValue = set.getNumber(columnIndex);
                        if (numberValue == null) {
                            throw new UnexpectedValueTypeException(2, rowNumber, columnIndex, (Object)set.getString(columnIndex));
                        }
                        values[activeAttributeIndex] = numberValue.doubleValue();
                        break block24;
                    }
                    if (column.getValueType() == 6 || column.getValueType() == 1 || Ontology.ATTRIBUTE_VALUE_TYPE.isA(column.getValueType(), 1)) {
                        try {
                            values[activeAttributeIndex] = activeAttributes.get(activeAttributeIndex).getMapping().mapString(set.getString(columnIndex));
                            break block24;
                        }
                        catch (AttributeTypeException e2) {
                            if (this.isErrorTolerant()) {
                                column.setValueType(1);
                                Attribute att = column.createAttribute();
                                for (String value : activeAttributes.get(columnIndex).getMapping().getValues()) {
                                    att.getMapping().mapString(value);
                                }
                                values[activeAttributeIndex] = att.getMapping().mapString(set.getString(columnIndex));
                                activeAttributes.set(columnIndex, att);
                                break block24;
                            }
                            throw new AttributeTypeException("Attribute: " + column.getName() + ", Index: " + columnIndex + ", Row: " + rowNumber + "\n\n" + e2.getMessage());
                        }
                    }
                    throw new OperatorException("The value type of the attribute " + column.getName() + " is unknown.");
                }
                catch (UnexpectedValueTypeException e3) {
                    if (this.isErrorTolerant()) {
                        values[activeAttributeIndex] = Double.NaN;
                        this.logReadingError(e3);
                    }
                    throw e3;
                }
            }
            ++activeAttributeIndex;
        }
        return values;
    }

    private void adjustAttributeColumnsNumbers(int newNumberOfColumns) {
        if (this.getAllAttributeColumns().size() < newNumberOfColumns) {
            int actualNumberOfAttributes = this.getAllAttributeColumns().size();
            int numberOfNewColumns = newNumberOfColumns - actualNumberOfAttributes;
            String[] genericNames = new String[numberOfNewColumns];
            for (int i = 0; i < numberOfNewColumns; ++i) {
                genericNames[i] = this.getNewGenericColumnName(actualNumberOfAttributes + i);
            }
            for (String name : genericNames) {
                this.attributeColumns.add(new AttributeColumn(name));
            }
        }
        if (this.getAllAttributeColumns().size() > newNumberOfColumns) {
            ArrayList<AttributeColumn> list = new ArrayList<AttributeColumn>();
            for (int i = 0; i < newNumberOfColumns; ++i) {
                list.add(this.getAttributeColumn(i));
            }
            this.attributeColumns = list;
        }
    }

    protected void setAttributeNames(String[] newColumnNames) {
        this.adjustAttributeColumnsNumbers(newColumnNames.length);
        assert (this.attributeColumns.size() == newColumnNames.length);
        if (this.attributeNamesDefinedByUser()) {
            return;
        }
        List<AttributeColumn> allAttributeColumns = this.getAllAttributeColumns();
        String[] oldColumnNames = new String[allAttributeColumns.size()];
        int i = 0;
        for (AttributeColumn column : allAttributeColumns) {
            oldColumnNames[i] = column.getName();
            ++i;
        }
        newColumnNames = this.getGenericColumnNames(newColumnNames, oldColumnNames);
        i = 0;
        for (AttributeColumn column : allAttributeColumns) {
            column.setName(newColumnNames[i]);
            ++i;
        }
    }

    protected void resetColumnNames() {
        int i = 0;
        for (AttributeColumn column : this.getAllAttributeColumns()) {
            column.setName(this.getNewGenericColumnName(i));
            ++i;
        }
    }

    public void stopReading() {
        this.stopReading = true;
    }

    protected void setAnnotations(Annotations[] annotations) {
        assert (this.getAllAttributeColumns().size() == annotations.length);
        int i = 0;
        for (AttributeColumn column : this.getAllAttributeColumns()) {
            column.getAnnotations().clear();
            column.getAnnotations().putAll(annotations[i]);
            ++i;
        }
    }

    protected void setValueTypes(List<Integer> valueTypesList) throws OperatorException {
        if (this.getAllAttributeColumns().size() != valueTypesList.size()) {
            throw new OperatorException("Internal error: The number of valueTypes does not match with the number of attributes.");
        }
        Iterator<Integer> it = valueTypesList.iterator();
        for (AttributeColumn column : this.getAllAttributeColumns()) {
            column.setValueType(it.next());
        }
    }

    private void logReadingError(OperatorException e) {
        this.importErrors.add(e);
    }

    public List<OperatorException> getImportErrors() {
        return this.importErrors;
    }

    public List<Object[]> getShortPreviewAsList(ProgressListener progress, boolean trimAttributeColumns) throws OperatorException {
        return this.getPreviewAsList(progress, false, trimAttributeColumns, 300);
    }

    public List<Object[]> getPreviewAsList(ProgressListener progress, boolean trimAttributeColumns) throws OperatorException {
        if (this.detectErrorsInPreview) {
            return this.getPreviewAsList(progress, true, trimAttributeColumns, -1);
        }
        return this.getShortPreviewAsList(progress, trimAttributeColumns);
    }

    public List<Object[]> getErrorPreviewAsList(ProgressListener progress) throws OperatorException {
        List<Object[]> preview = this.getPreviewAsList(progress, true, false, -1);
        LinkedList<Object[]> errorPreview = new LinkedList<Object[]>();
        Iterator<Object[]> it = preview.iterator();
        int rowNum = 0;
        while (it.hasNext()) {
            Object[] row = it.next();
            if (this.hasParseErrorInRow(rowNum)) {
                errorPreview.add(row);
            }
            ++rowNum;
        }
        return errorPreview;
    }

    public List<Object[]> getPreviewAsList(ProgressListener progress, boolean enableErrorDetection, boolean trimAttributeColumns, int numberOfLinesRead) throws OperatorException {
        int hundredPercent;
        this.stopReading = false;
        int limit = numberOfLinesRead;
        if (progress != null) {
            progress.setTotal(this.rowCountFromGuessing);
        }
        hundredPercent = (hundredPercent = this.rowCountFromGuessing / 100) == 0 ? 10 : hundredPercent;
        this.rowCountFromGuessing = 0;
        if (numberOfLinesRead < 0) {
            limit = this.rowCountFromGuessing + 1;
        }
        this.errorCells.clear();
        for (AttributeColumn column : this.getAllAttributeColumns()) {
            column.valueSet.clear();
        }
        DataSet set = null;
        try {
            set = this.getDataSet();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 403, e.getMessage());
        }
        LinkedList<Object[]> preview = new LinkedList<Object[]>();
        int currentRow = 1;
        UnexpectedRowLenghtException rowLenghtWarning = null;
        while (!this.stopReading && set.next() && this.rowCountFromGuessing < limit) {
            rowLenghtWarning = null;
            if (progress != null && currentRow % hundredPercent == 0) {
                progress.setCompleted(currentRow);
            }
            int actualColumnCount = set.getNumberOfColumnsInCurrentRow();
            if (this.getAllAttributeColumns().size() < actualColumnCount || this.getAllAttributeColumns().size() > actualColumnCount) {
                if (this.rowCountFromGuessing > 0) {
                    this.foundParseError(-1, this.rowCountFromGuessing);
                    if (this.getAllAttributeColumns().size() > actualColumnCount) {
                        rowLenghtWarning = new TooShortRowLengthException(currentRow, actualColumnCount, this.getAllAttributeColumns().size());
                    }
                    if (this.getAllAttributeColumns().size() < actualColumnCount) {
                        rowLenghtWarning = new TooLongRowLengthException(currentRow, actualColumnCount, this.getAllAttributeColumns().size());
                        this.adjustAttributeColumnsNumbers(actualColumnCount);
                    }
                } else if (trimAttributeColumns) {
                    this.adjustAttributeColumnsNumbers(actualColumnCount);
                }
            }
            Object[] values = new Object[actualColumnCount + 1];
            values[0] = currentRow;
            ++currentRow;
            for (int i = 0; i < actualColumnCount; ++i) {
                AttributeColumn column = this.getAttributeColumn(i);
                if (set.isMissing(i)) {
                    values[i + 1] = "";
                    continue;
                }
                if (enableErrorDetection) {
                    if (column.getValueType() == 10 || column.getValueType() == 11 || column.getValueType() == 9) {
                        values[i + 1] = set.getDate(i);
                    } else if (column.getValueType() == 3 || column.getValueType() == 4 || column.getValueType() == 2) {
                        values[i + 1] = set.getNumber(i);
                    } else if (column.getValueType() == 6) {
                        values[i + 1] = set.getString(i);
                        if (values[i + 1] != null) {
                            if (column.valueSet.size() >= 2) {
                                if (!column.valueSet.contains(values[i + 1]) && column.isActivated) {
                                    this.foundParseError(i, this.rowCountFromGuessing);
                                }
                            } else {
                                column.valueSet.add((String)values[i + 1]);
                            }
                        }
                    } else if (column.getValueType() == 1) {
                        values[i + 1] = set.getString(i);
                        column.valueSet.add((String)values[i + 1]);
                    }
                    if (values[i + 1] != null) continue;
                    values[i + 1] = set.getString(i);
                    if (!column.isActivated) continue;
                    this.foundParseError(i, this.rowCountFromGuessing);
                    continue;
                }
                values[i + 1] = set.getString(i);
            }
            preview.add(values);
            ++this.rowCountFromGuessing;
            if (numberOfLinesRead < 0) {
                limit = this.rowCountFromGuessing + 1;
            }
            if (rowLenghtWarning == null) continue;
        }
        set.close();
        this.guessedValueTypes = true;
        return preview;
    }

    private void foundParseError(int column, int row) {
        TreeSet<Integer> treeSet = this.errorCells.get(column);
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.errorCells.put(column, new TreeSet());
        }
        treeSet.add(row);
    }

    public boolean hasParseErrorInColumn(int column) {
        TreeSet<Integer> treeSet = this.errorCells.get(column);
        return treeSet != null && !treeSet.isEmpty();
    }

    public boolean hasParseErrorInRow(int row) {
        for (int column : this.errorCells.keySet()) {
            if (!this.hasParseError(column, row)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParseError(int column, int row) {
        TreeSet<Integer> treeSet = this.errorCells.get(column);
        if (treeSet != null) {
            return treeSet.contains(row);
        }
        return false;
    }

    public boolean isDetectErrorsInPreview() {
        return this.detectErrorsInPreview;
    }

    public void setDetectErrorsInPreview(boolean detectErrorsInPreview) {
        this.detectErrorsInPreview = detectErrorsInPreview;
    }

    @Override
    protected boolean isMetaDataCacheable() {
        return true;
    }

    protected String getNewGenericColumnName(int column) {
        HashSet<String> usedNames = new HashSet<String>();
        for (AttributeColumn col : this.getAllAttributeColumns()) {
            usedNames.add(col.getName());
        }
        while (usedNames.contains("attribute_" + column)) {
            ++column;
        }
        return "attribute_" + column;
    }

    private String[] getGenericColumnNames(String[] proposedNames, String[] oldColumnNames) {
        HashSet<String> usedNames = new HashSet<String>();
        for (AttributeColumn col : this.getAllAttributeColumns()) {
            usedNames.add(col.getName());
        }
        int offset = usedNames.size();
        String[] genericNames = new String[proposedNames.length];
        for (int i = 0; i < proposedNames.length; ++i) {
            String proposedName = proposedNames[i];
            if (proposedName == null) {
                proposedName = "attribute_" + (offset + i + 1);
            }
            if (!proposedName.equals(oldColumnNames[i])) {
                if (usedNames.contains(proposedName)) {
                    proposedName = proposedName + "_" + (offset + i + 1);
                }
                usedNames.add(proposedName);
            }
            genericNames[i] = proposedName;
        }
        return genericNames;
    }

    public void guessValueTypes(ProgressListener progress) throws OperatorException {
        int tenPercent;
        this.stopReading = false;
        DataSet set = null;
        try {
            set = this.getDataSet();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 403, e.getMessage());
        }
        if (progress != null) {
            progress.setTotal(300);
        }
        tenPercent = (tenPercent = 30) == 0 ? 10 : tenPercent;
        this.rowCountFromGuessing = 0;
        int linesTried = 0;
        while (!this.stopReading && set.next() && linesTried <= 300) {
            ++this.rowCountFromGuessing;
            if (this.rowCountFromGuessing > 20 & this.rowCountFromGuessing % 10 != 0) continue;
            if (progress != null && linesTried % tenPercent == 0) {
                progress.setCompleted(linesTried);
            }
            ++linesTried;
            int actualColumnCount = set.getNumberOfColumnsInCurrentRow();
            if (this.getAllAttributeColumns().size() < actualColumnCount) {
                this.adjustAttributeColumnsNumbers(actualColumnCount);
            }
            Object[] values = new Object[actualColumnCount];
            Calendar lastDateCalendar = Calendar.getInstance();
            Calendar currDateCalendar = Calendar.getInstance();
            for (int i = 0; i < actualColumnCount; ++i) {
                String string;
                AttributeColumn column = this.getAttributeColumn(i);
                if (set.isMissing(i)) {
                    column.incNummerOfMissing();
                    values[i] = null;
                    continue;
                }
                if (column.canParseDouble) {
                    Number number = set.getNumber(i);
                    if (number != null) {
                        if (Double.isNaN(number.doubleValue())) {
                            column.incNummerOfMissing();
                            continue;
                        }
                        if (column.minValue > number.doubleValue()) {
                            column.minValue = number.doubleValue();
                        }
                        if (column.maxValue < number.doubleValue()) {
                            column.maxValue = number.doubleValue();
                        }
                        if (column.canParseInteger && !Tools.isEqual(Math.round(number.doubleValue()), number.doubleValue())) {
                            column.canParseInteger = false;
                        }
                        values[i] = number;
                        if (column.valueSet.size() > 2) continue;
                        column.valueSet.add(number.toString());
                        continue;
                    }
                    column.canParseDouble = false;
                    column.canParseInteger = false;
                }
                if (column.canParseDate) {
                    Date date = set.getDate(i);
                    if (date != null) {
                        values[i] = date;
                        if (column.lastDate != null) {
                            lastDateCalendar.setTime(column.lastDate);
                            currDateCalendar.setTime(date);
                            if (!(column.shouldBeDate || lastDateCalendar.get(5) == currDateCalendar.get(5) && lastDateCalendar.get(2) == currDateCalendar.get(2) && lastDateCalendar.get(1) == currDateCalendar.get(1))) {
                                column.shouldBeDate = true;
                            }
                            if (!(column.shouldBeTime || lastDateCalendar.get(11) == currDateCalendar.get(11) && lastDateCalendar.get(12) == currDateCalendar.get(12) && lastDateCalendar.get(13) == currDateCalendar.get(13) && lastDateCalendar.get(14) == currDateCalendar.get(14))) {
                                column.shouldBeTime = true;
                            }
                        }
                        column.lastDate = date;
                        if (column.minValue > (double)date.getTime()) {
                            column.minValue = date.getTime();
                        }
                        if (column.maxValue < (double)date.getTime()) {
                            column.maxValue = date.getTime();
                        }
                        if (column.valueSet.size() > 2) continue;
                        column.valueSet.add(date.toString());
                        continue;
                    }
                    column.canParseDate = false;
                }
                if ((string = set.getString(i)) != null && !string.isEmpty()) {
                    values[i] = string;
                    if (column.valueSet.size() > 2) continue;
                    column.valueSet.add(string);
                    continue;
                }
                column.incNummerOfMissing();
                values[i] = null;
            }
        }
        set.close();
        int debugColumnCount = -1;
        for (AttributeColumn column : this.getAllAttributeColumns()) {
            ++debugColumnCount;
            if (column.numberOfMissings == this.rowCountFromGuessing) {
                column.setValueType(1);
                continue;
            }
            if (column.canParseInteger) {
                column.setValueType(3);
                continue;
            }
            if (column.canParseDouble) {
                column.setValueType(4);
                continue;
            }
            if (column.canParseDate) {
                if (column.shouldBeDate && column.shouldBeTime) {
                    column.setValueType(9);
                    continue;
                }
                if (column.shouldBeDate) {
                    column.setValueType(10);
                    continue;
                }
                if (column.shouldBeTime) {
                    column.setValueType(11);
                    continue;
                }
                throw new OperatorException("Could not determine the value type of the attribute " + column.getName() + " in column number " + this.getIndexOfAttributeColumn(column) + ".");
            }
            if (column.valueSet.size() <= 2) {
                column.setValueType(6);
                continue;
            }
            column.setValueType(1);
        }
        this.guessedValueTypes = true;
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        return this.createExampleSet(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExampleSet createExampleSet(int limitOfReadLines) throws OperatorException {
        ArrayList<Attribute> activeAttributes = new ArrayList<Attribute>();
        if (this.attributeNamesDefinedByUser()) {
            this.loadMetaDataFromParameters();
        } else {
            this.clearAllReaderSettings();
            this.guessValueTypes(null);
        }
        DataSet set = null;
        try {
            set = this.getDataSet();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 403, e.getMessage());
        }
        for (AttributeColumn column : this.getActiveAttributeColumns()) {
            activeAttributes.add(column.getAttribute());
        }
        LinkedList<double[]> dataRows = new LinkedList<double[]>();
        for (int lineCount = 0; set.next() && (limitOfReadLines == -1 || limitOfReadLines > lineCount); ++lineCount) {
            double[] row = this.generateRow(set, activeAttributes, lineCount);
            dataRows.add(row);
            try {
                this.checkForStop();
                continue;
            }
            catch (ProcessStoppedException e) {
                dataRows = null;
                set.close();
                set = null;
                throw e;
            }
        }
        MemoryExampleTable table = new MemoryExampleTable(activeAttributes);
        Iterator rowIt = dataRows.iterator();
        double[] row = null;
        try {
            while (rowIt.hasNext()) {
                row = (double[])rowIt.next();
                if (row.length < activeAttributes.size()) {
                    double[] values = new double[activeAttributes.size()];
                    System.arraycopy(row, 0, values, 0, row.length);
                    for (int i = row.length; i < values.length; ++i) {
                        values[i] = Double.NaN;
                    }
                    row = values;
                }
                table.addDataRow(new DoubleArrayDataRow(row));
                this.checkForStop();
            }
            ExampleSet exampleSet = table.createExampleSet();
            for (AttributeColumn column : this.getActiveAttributeColumns()) {
                if (column.getRole().equals("regular")) continue;
                exampleSet.getAttributes().setSpecialAttribute(exampleSet.getAttributes().get(column.getName()), column.getRole());
            }
            this.addAnnotations(exampleSet);
            ExampleSet exampleSet2 = exampleSet;
            return exampleSet2;
        }
        finally {
            set.close();
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.addAll(super.getParameterTypes());
        types.add(new ParameterTypeBoolean(PARAMETER_ERROR_TOLERANT, "Values which does not match to the specified value typed are considered as missings.", true, true));
        String[] roles = new String[ROLE_NAMES.size()];
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = ROLE_NAMES.get(i);
        }
        ParameterTypeList typeList = new ParameterTypeList(PARAMETER_META_DATA, "The meta data information", (ParameterType)new ParameterTypeInt(PARAMETER_COLUMN_INDEX, "The column index", 0, 9999), (ParameterType)new ParameterTypeTupel(PARAMETER_COLUMN_META_DATA, "the meta data information of one column", new ParameterTypeString(PARAMETER_COLUMN_NAME, "Describes the attributes name."), new ParameterTypeBoolean(PARAMETER_COLUMN_SELECTED, "Indicates if a column is selected", true), new ParameterTypeCategory(PARAMETER_COLUM_VALUE_TYPE, "Indicates the value type of an attribute", Ontology.VALUE_TYPE_NAMES, 1), new ParameterTypeStringCategory(PARAMETER_COLUM_ROLE, "Indicates the role of an attribute", roles, "regular")));
        typeList.setHidden(true);
        types.add(typeList);
        ParameterTypeBoolean typeBool = new ParameterTypeBoolean(PARAMETER_ATTRIBUTE_NAMES_DEFINED_BY_USER, "the parameter describes whether the attribute names were set by the user manually or were generated by the the reader (generic names or first row of the file)", false);
        typeBool.setHidden(true);
        types.add(typeBool);
        return types;
    }

    public void setErrorTolerant(boolean flag) {
        this.isErrorTollerantCache = flag;
        this.setParameter(PARAMETER_ERROR_TOLERANT, Boolean.toString(flag));
    }

    public boolean isErrorTolerant() {
        return this.isErrorTollerantCache;
    }

    protected abstract class DataSet {
        protected DataSet() {
        }

        public abstract boolean next();

        public abstract int getNumberOfColumnsInCurrentRow();

        public abstract boolean isMissing(int var1);

        public abstract Number getNumber(int var1);

        public abstract String getString(int var1);

        public abstract Date getDate(int var1);

        public abstract void close() throws OperatorException;
    }

    public class AttributeColumn {
        public static final int NAME_PARAMETER = 0;
        public static final int IS_ACTIVATED_PARAMETER = 1;
        public static final int VALUE_TYPE_PARAMETER = 2;
        public static final int ROLE_PARAMETER = 3;
        public static final String REGULAR = "regular";
        private String name;
        private String role = "regular";
        private boolean isActivated = true;
        private int valueType = 1;
        private Attribute attribute = null;
        private Annotations annotations = new Annotations();
        protected double minValue = Double.NEGATIVE_INFINITY;
        protected double maxValue = Double.POSITIVE_INFINITY;
        protected Set<String> valueSet = new LinkedHashSet<String>();
        protected int numberOfMissings = 0;
        private boolean canParseDouble = true;
        private boolean canParseInteger = true;
        private boolean canParseDate = true;
        private boolean shouldBeDate = false;
        private boolean shouldBeTime = false;
        private Date lastDate = null;

        public String toString() {
            return this.name + "," + this.isActivated + "," + this.valueType + "," + this.role + "," + this.annotations;
        }

        public int incNummerOfMissing() {
            return this.numberOfMissings++;
        }

        public Annotations getAnnotations() {
            return this.annotations;
        }

        private Attribute createAttribute() {
            Attribute att = AttributeFactory.createAttribute(this.getName(), this.getValueType());
            att.getAnnotations().clear();
            att.getAnnotations().putAll(this.getAnnotations());
            this.attribute = att;
            return att;
        }

        public Attribute getAttribute() {
            if (this.attribute == null) {
                return this.createAttribute();
            }
            if (!this.attribute.getName().equals(this.getName())) {
                return this.createAttribute();
            }
            if (this.attribute.getValueType() != this.getValueType()) {
                return this.createAttribute();
            }
            for (String key : this.getAnnotations().getKeys()) {
                if (this.attribute.getAnnotations().get(key).equals(this.getAnnotations().get(key))) continue;
                return this.createAttribute();
            }
            return this.attribute;
        }

        public boolean isActivated() {
            return this.isActivated;
        }

        public void activateColumn(boolean flag) {
            this.isActivated = flag;
        }

        public int getValueType() {
            return this.valueType;
        }

        public void setValueType(int newValueType) {
            this.valueType = newValueType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        private String getMetaParameter(int parameterIndex) {
            int index = AbstractDataReader.this.getIndexOfAttributeColumn(this);
            try {
                List<String[]> list = AbstractDataReader.this.getParameterList(AbstractDataReader.PARAMETER_META_DATA);
                String[] map = null;
                for (String[] m : list) {
                    if (Integer.parseInt(m[0]) != index) continue;
                    map = m;
                    break;
                }
                if (map == null) {
                    return null;
                }
                void tuple = map[1];
                String[] metadata = ParameterTypeTupel.transformString2Tupel((String)tuple);
                return metadata[parameterIndex];
            }
            catch (UndefinedParameterError e) {
                e.printStackTrace();
                return null;
            }
        }

        private void loadMetaParameter() {
            String s;
            if (this.getMetaParameter(0) != null) {
                this.setName(this.getMetaParameter(0));
            }
            if ((s = this.getMetaParameter(2)) != null) {
                this.setValueType(Integer.parseInt(s));
            }
            if (this.getMetaParameter(3) != null) {
                this.setRole(this.getMetaParameter(3));
            }
            if (this.getMetaParameter(1) != null) {
                this.activateColumn(Boolean.parseBoolean(this.getMetaParameter(1)));
            }
        }

        private void setMetaParameter() {
            int myIndex = AbstractDataReader.this.getIndexOfAttributeColumn(this);
            try {
                String tuple;
                String[] metadata;
                List<String[]> list = AbstractDataReader.this.getParameterList(AbstractDataReader.PARAMETER_META_DATA);
                String[] map = null;
                for (String[] mapIndexToValues : list) {
                    if (Integer.parseInt(mapIndexToValues[0]) != myIndex) continue;
                    map = mapIndexToValues;
                    break;
                }
                if (map == null) {
                    map = new String[2];
                    map[0] = Integer.toString(myIndex);
                    list.add(map);
                    metadata = new String[4];
                } else {
                    tuple = map[1];
                    metadata = ParameterTypeTupel.transformString2Tupel(tuple);
                }
                metadata[0] = this.name;
                metadata[1] = Boolean.toString(this.isActivated);
                metadata[2] = Integer.toString(this.valueType);
                metadata[3] = this.role;
                map[1] = tuple = ParameterTypeTupel.transformTupel2String(metadata);
                String entry = ParameterTypeList.transformList2String(list);
                AbstractDataReader.this.setParameter(AbstractDataReader.PARAMETER_META_DATA, entry);
            }
            catch (UndefinedParameterError e) {
                e.printStackTrace();
            }
        }

        public AttributeColumn(String attributeName) {
            this.setName(attributeName);
        }
    }

    public static class UnexpectedValueTypeException
    extends OperatorException {
        private static final long serialVersionUID = 1L;
        private int expectedValueType = -1;
        private int row = -1;
        private int column = -1;
        private Object value = null;

        public UnexpectedValueTypeException(String message, int expectedValueType, int column, int row, Object value) {
            super(message);
            this.expectedValueType = expectedValueType;
            this.row = row;
            this.column = column;
            this.value = value;
        }

        public UnexpectedValueTypeException(int expectedValueType, int column, int row, Object value) {
            this("Could not interpreted the value <b>" + value + "<//b> in row <b>" + row + "<//b> and column <b>" + column + "<//b> as a <b>" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(expectedValueType) + "<//b>. Plaese adjust to a proper value type or enable the operator's error tolerance.", expectedValueType, column, row, value);
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public Object getValue() {
            return this.value;
        }

        public int getExpectedValueType() {
            return this.expectedValueType;
        }
    }

    public class TooLongRowLengthException
    extends UnexpectedRowLenghtException {
        private static final long serialVersionUID = -9079042758212112074L;

        public TooLongRowLengthException(int rowNumber, int rowLenght, int expectedRowLenght) {
            super("Row number <b>" + rowNumber + "</b> is too <b>long</b>. It has <b>" + rowLenght + "</b> columns but it is expected to have <b>" + expectedRowLenght + "</b> columns.", rowNumber, rowLenght, expectedRowLenght);
        }
    }

    public class TooShortRowLengthException
    extends UnexpectedRowLenghtException {
        private static final long serialVersionUID = -9183147637149034838L;

        public TooShortRowLengthException(int rowNumber, int rowLenght, int expectedRowLenght) {
            super("Row number <b>" + rowNumber + "<//b> is too <b>short<//b>. The row has <b>" + rowLenght + "<//b> columns but it is expected to have <b>" + expectedRowLenght + "<//b> columns.", rowNumber, rowLenght, expectedRowLenght);
        }
    }

    private abstract class UnexpectedRowLenghtException
    extends OperatorException {
        private static final long serialVersionUID = 1L;
        private int rowNumber;
        private int rowLenght;
        int expectedRowLenght;

        public UnexpectedRowLenghtException(String message, int rowNumber, int rowLenght, int expectedRowLenght) {
            super(message);
            this.rowNumber = -1;
            this.rowLenght = -1;
            this.expectedRowLenght = -1;
            this.rowNumber = rowNumber;
            this.rowLenght = rowLenght;
            this.expectedRowLenght = expectedRowLenght;
        }

        public UnexpectedRowLenghtException(int rowNumber, int rowLenght, int expectedRowLenght) {
            super("NO MESSAGE");
            this.rowNumber = -1;
            this.rowLenght = -1;
            this.expectedRowLenght = -1;
            this.rowNumber = rowNumber;
        }

        public int getRow() {
            return this.rowNumber;
        }

        public int getRowLenght() {
            return this.rowLenght;
        }

        public int getExpectedRowLenght() {
            return this.expectedRowLenght;
        }
    }

    protected class CacheResetParameterObserver
    implements Observer<String> {
        private String parameterKey;
        private String oldFilename;

        protected CacheResetParameterObserver(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        @Override
        public void update(Observable<String> observable, String arg) {
            if (arg == null || !arg.equals("file_name") || arg.equals("excel_file")) {
                return;
            }
            String newFilename = AbstractDataReader.this.getParameters().getParameterOrNull(this.parameterKey);
            if (newFilename == null && this.oldFilename != null || newFilename != null && this.oldFilename == null || newFilename != null && this.oldFilename != null && !newFilename.equals(this.oldFilename)) {
                AbstractDataReader.this.clearAllReaderSettings();
                this.oldFilename = newFilename;
            }
        }
    }
}

