/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.container.Range;
import java.util.ArrayList;
import java.util.List;

public class TransfersExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    public static final String PARAMETER_CREATE_FRAUD_LABEL = "create_fraud_label";
    private static String[] ATTRIBUTE_NAMES = new String[]{"Source", "Target", "ProjectID", "Reason", "Person", "Amount"};
    private static int[] VALUE_TYPES = new int[]{1, 1, 1, 3, 1, 4};
    private static String[][] POSSIBLE_VALUES = new String[][]{{"1201", "1302", "4517", "4711", "2323", "1110", "2233"}, {"1201", "1302", "4517", "4711", "2323", "1110", "2233"}, {"Prj01", "Prj02", "Prj03", "Prj04", "Prj05", "Prj06", "Prj07", "Prj08"}, null, {"Mr. Brown", "Mr. Miller", "Mrs. Smith", "Mrs. Hanson", "Mrs. Green", "Mr. Chang"}, null};

    public TransfersExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute id = AttributeFactory.createAttribute("TransferID", 3);
        attributes.add(id);
        for (int m = 0; m < ATTRIBUTE_NAMES.length; ++m) {
            Attribute current = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[m], VALUE_TYPES[m]);
            String[] possibleValues = POSSIBLE_VALUES[m];
            if (possibleValues != null) {
                for (int v = 0; v < possibleValues.length; ++v) {
                    current.getMapping().mapString(possibleValues[v]);
                }
            }
            attributes.add(current);
        }
        boolean createFraudLabel = this.getParameterAsBoolean(PARAMETER_CREATE_FRAUD_LABEL);
        Attribute label = null;
        if (createFraudLabel) {
            label = AttributeFactory.createAttribute("fraud", 1);
            label.getMapping().mapString("yes");
            label.getMapping().mapString("no");
            attributes.add(label);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        for (int n = 0; n < numberOfExamples; ++n) {
            int specialLength = createFraudLabel ? 2 : 1;
            double[] values = new double[ATTRIBUTE_NAMES.length + specialLength];
            values[0] = n + 1;
            values[1] = random.nextInt(POSSIBLE_VALUES[0].length);
            values[2] = random.nextInt(POSSIBLE_VALUES[1].length);
            values[3] = random.nextInt(POSSIBLE_VALUES[2].length);
            values[4] = random.nextIntInRange(10000, 99999);
            values[5] = random.nextInt(POSSIBLE_VALUES[4].length);
            values[6] = Math.round(random.nextGaussian() * 15000.0) + 50000L;
            if (createFraudLabel) {
                values[7] = label.getMapping().mapString("no");
                if (!(values[1] != 3.0 && values[1] != 4.0 || values[2] != 1.0 && values[2] != 2.0 || !(random.nextDouble() > 0.05))) {
                    values[7] = label.getMapping().mapString("yes");
                }
            }
            table.addDataRow(new DoubleArrayDataRow(values));
        }
        if (createFraudLabel) {
            return table.createExampleSet(label, null, id);
        }
        return table.createExampleSet(null, null, id);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_CREATE_FRAUD_LABEL, "Indicates if a label should be created for possible frauds.", false);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        ExampleSetMetaData emd = new ExampleSetMetaData();
        emd.addAttribute(new AttributeMetaData("TransferID", 3, "id"));
        emd.addAttribute(new AttributeMetaData("Source", null, POSSIBLE_VALUES[0]));
        emd.addAttribute(new AttributeMetaData("Target", null, POSSIBLE_VALUES[1]));
        emd.addAttribute(new AttributeMetaData("ProjectID", null, POSSIBLE_VALUES[2]));
        emd.addAttribute(new AttributeMetaData("Reason", null, 3, new Range(10000.0, 99999.0)));
        emd.addAttribute(new AttributeMetaData("Person", null, POSSIBLE_VALUES[1]));
        emd.addAttribute(new AttributeMetaData("Amount", null, 3, new Range(50000.0, Double.POSITIVE_INFINITY)));
        emd.setNumberOfExamples(this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES));
        return emd;
    }
}

