/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.container.Range;

public class TransactionDatasetFunction
implements TargetFunction {
    private int numberOfExamples;
    private int numberOfAttributes;

    @Override
    public void init(RandomGenerator random) {
    }

    @Override
    public void setTotalNumberOfExamples(int number) {
        this.numberOfExamples = number;
    }

    @Override
    public void setTotalNumberOfAttributes(int number) {
        this.numberOfAttributes = number;
    }

    @Override
    public void setLowerArgumentBound(double lower) {
    }

    @Override
    public void setUpperArgumentBound(double upper) {
    }

    @Override
    public Attribute getLabel() {
        return null;
    }

    @Override
    public double calculate(double[] att) throws TargetFunction.FunctionException {
        if (att.length < 5) {
            throw new TargetFunction.FunctionException("Association function", "needs at least 5 attributes!");
        }
        return Double.NaN;
    }

    @Override
    public double[] createArguments(int number, RandomGenerator random) throws TargetFunction.FunctionException {
        if (number < 5) {
            throw new TargetFunction.FunctionException("Association function", "needs at least 5 attributes!");
        }
        double[] args = new double[number];
        for (int i = 0; i < args.length; ++i) {
            args[i] = random.nextDouble() < 0.1 ? 1.0 : 0.0;
        }
        if (args[1] == 1.0 && random.nextDouble() < 0.8) {
            args[3] = 1.0;
        }
        if (args[0] == 1.0 && random.nextDouble() < 0.9) {
            args[1] = 1.0;
        }
        if (args[0] == 1.0 && random.nextDouble() < 0.7) {
            args[2] = 1.0;
        }
        return args;
    }

    @Override
    public ExampleSetMetaData getGeneratedMetaData() {
        ExampleSetMetaData emd = new ExampleSetMetaData();
        for (int i = 1; i <= this.numberOfAttributes; ++i) {
            AttributeMetaData amd = new AttributeMetaData("att" + i, 4);
            amd.setValueRange(new Range(0.0, 1.0), SetRelation.EQUAL);
        }
        emd.setNumberOfExamples(this.numberOfExamples);
        return emd;
    }
}

