/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.container.Range;
import java.util.ArrayList;
import java.util.List;

public class TransactionClustersExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_TRANSACTIONS = "number_transactions";
    public static final String PARAMETER_NUMBER_CUSTOMERS = "number_customers";
    public static final String PARAMETER_NUMBER_ITEMS = "number_items";
    public static final String PARAMETER_NUMBER_CLUSTERS = "number_clusters";

    public TransactionClustersExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int n;
        int numberOfTransactions = this.getParameterAsInt(PARAMETER_NUMBER_TRANSACTIONS);
        int numberOfCustomers = this.getParameterAsInt(PARAMETER_NUMBER_CUSTOMERS);
        int numberOfClusters = this.getParameterAsInt(PARAMETER_NUMBER_CLUSTERS);
        int numberOfItems = this.getParameterAsInt(PARAMETER_NUMBER_ITEMS);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute id = AttributeFactory.createAttribute("Id", 1);
        for (int i = 1; i <= numberOfCustomers; ++i) {
            id.getMapping().mapString("Id " + i);
        }
        attributes.add(id);
        Attribute item = AttributeFactory.createAttribute("Item", 1);
        for (int i = 1; i <= numberOfItems; ++i) {
            item.getMapping().mapString("Item " + i);
        }
        attributes.add(item);
        Attribute amount = AttributeFactory.createAttribute("Amount", 3);
        attributes.add(amount);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        double[][] probs = new double[numberOfClusters][numberOfItems];
        int[] maxItems = new int[numberOfClusters];
        for (int c = 0; c < numberOfClusters; ++c) {
            int i;
            double sum = 0.0;
            for (i = 0; i < numberOfItems; ++i) {
                probs[c][i] = random.nextDouble();
                sum += probs[c][i];
            }
            i = 0;
            while (i < numberOfItems) {
                double[] dArray = probs[c];
                int n2 = i++;
                dArray[n2] = dArray[n2] / sum;
            }
            maxItems[c] = random.nextIntInRange(5, 20);
        }
        double clusterSize = Math.ceil((double)numberOfCustomers / (double)numberOfClusters);
        for (n = 0; n < numberOfCustomers; ++n) {
            double[] values = new double[3];
            values[0] = id.getMapping().mapString("Id " + (n + 1));
            int clusterIndex = Math.max(0, Math.min(numberOfClusters - 1, (int)Math.floor((double)(n + 1) / clusterSize)));
            double p = random.nextDouble();
            double sum = 0.0;
            int itemIndex = 0;
            double itemProb = 0.0;
            for (int i = 0; i < probs[clusterIndex].length; ++i) {
                if (p <= sum) {
                    itemIndex = i;
                    itemProb = probs[clusterIndex][i];
                    break;
                }
                sum += probs[clusterIndex][i];
            }
            values[1] = item.getMapping().mapString("Item " + (itemIndex + 1));
            values[2] = Math.round(Math.max(1.0, random.nextGaussian() * itemProb * (double)maxItems[clusterIndex]));
            table.addDataRow(new DoubleArrayDataRow(values));
        }
        for (n = numberOfCustomers; n < numberOfTransactions; ++n) {
            double[] values = new double[3];
            int idNumber = random.nextIntInRange(1, numberOfCustomers + 1);
            values[0] = id.getMapping().mapString("Id " + idNumber);
            int clusterIndex = Math.max(0, Math.min(numberOfClusters - 1, (int)Math.floor((double)idNumber / clusterSize)));
            double p = random.nextDouble();
            double sum = 0.0;
            int itemIndex = 0;
            double itemProb = 0.0;
            if (random.nextDouble() < 0.05) {
                itemIndex = random.nextIntInRange(0, numberOfItems);
            } else {
                for (int i = 0; i < probs[clusterIndex].length; ++i) {
                    if (p <= sum) {
                        itemIndex = i;
                        itemProb = probs[clusterIndex][i];
                        break;
                    }
                    sum += probs[clusterIndex][i];
                }
            }
            values[1] = item.getMapping().mapString("Item " + (itemIndex + 1));
            values[2] = Math.round(Math.max(1.0, random.nextGaussian() * itemProb * (double)maxItems[clusterIndex]));
            table.addDataRow(new DoubleArrayDataRow(values));
        }
        return table.createExampleSet(null, null, id);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_TRANSACTIONS, "The number of generated transactions.", 1, Integer.MAX_VALUE, 10000);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_CUSTOMERS, "The number of generated customers.", 1, Integer.MAX_VALUE, 1000);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_ITEMS, "The number of generated items.", 1, Integer.MAX_VALUE, 80);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_CLUSTERS, "The number of generated clusters.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        int i;
        ExampleSetMetaData emd = new ExampleSetMetaData();
        String[] possibleValues = new String[this.getParameterAsInt(PARAMETER_NUMBER_CUSTOMERS)];
        for (i = 0; i < possibleValues.length; ++i) {
            possibleValues[i] = "Id " + (i + 1);
        }
        emd.addAttribute(new AttributeMetaData("Id", null, possibleValues));
        possibleValues = new String[this.getParameterAsInt(PARAMETER_NUMBER_ITEMS)];
        for (i = 0; i < possibleValues.length; ++i) {
            possibleValues[i] = "Item " + (i + 1);
        }
        emd.addAttribute(new AttributeMetaData("Item", null, possibleValues));
        emd.addAttribute(new AttributeMetaData("Amount", null, 3, new Range(0.0, Double.POSITIVE_INFINITY)));
        emd.setNumberOfExamples(this.getParameterAsInt(PARAMETER_NUMBER_TRANSACTIONS));
        return emd;
    }
}

