/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.container.Range;
import java.util.ArrayList;
import java.util.List;

public class TeamProfitExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    private static String[] ATTRIBUTE_NAMES = new String[]{"size", "leader", "number of qualified employees", "leader changed", "average years of experience", "structure"};
    private static int[] VALUE_TYPES = new int[]{3, 1, 3, 6, 3, 6};
    private static String[][] POSSIBLE_VALUES = new String[][]{null, {"Mr. Brown", "Mr. Miller", "Mrs. Smith", "Mrs. Hanson", "Mrs. Green", "Mr. Chang"}, null, {"yes", "no"}, null, {"flat", "hierachical"}};

    public TeamProfitExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute id = AttributeFactory.createAttribute("teamID", 1);
        attributes.add(id);
        for (int m = 0; m < ATTRIBUTE_NAMES.length; ++m) {
            Attribute current = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[m], VALUE_TYPES[m]);
            String[] possibleValues = POSSIBLE_VALUES[m];
            if (possibleValues != null) {
                for (int v = 0; v < possibleValues.length; ++v) {
                    current.getMapping().mapString(possibleValues[v]);
                }
            }
            attributes.add(current);
        }
        Attribute label = AttributeFactory.createAttribute("label", 6);
        label.getMapping().mapString("good");
        label.getMapping().mapString("bad");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        for (int n = 0; n < numberOfExamples; ++n) {
            double[] values = new double[ATTRIBUTE_NAMES.length + 2];
            values[0] = ((Attribute)attributes.get(0)).getMapping().mapString("team_" + n);
            values[1] = random.nextIntInRange(5, 20);
            values[2] = random.nextInt(POSSIBLE_VALUES[1].length);
            values[3] = Math.round(random.nextDouble() * (values[1] - 1.0) + 1.0);
            values[4] = random.nextInt(POSSIBLE_VALUES[3].length);
            values[5] = random.nextIntInRange(1, 10);
            values[6] = random.nextInt(POSSIBLE_VALUES[5].length);
            values[7] = label.getMapping().mapString("bad");
            if (values[1] > 18.0) {
                if (random.nextDouble() > 0.05) {
                    values[7] = label.getMapping().mapString("good");
                }
            } else if (values[1] > 15.0) {
                if (random.nextDouble() > 0.1) {
                    values[7] = label.getMapping().mapString("good");
                }
            } else if (values[4] == 1.0 && random.nextDouble() > 0.1) {
                values[7] = label.getMapping().mapString("good");
            }
            table.addDataRow(new DoubleArrayDataRow(values));
        }
        return table.createExampleSet(label);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        ExampleSetMetaData emd = new ExampleSetMetaData();
        emd.addAttribute(new AttributeMetaData("label", "label", "good", "bad"));
        emd.addAttribute(new AttributeMetaData("teamID", 1));
        emd.addAttribute(new AttributeMetaData("size", null, 3, new Range(5.0, 20.0)));
        emd.addAttribute(new AttributeMetaData("leader", null, POSSIBLE_VALUES[1]));
        emd.addAttribute(new AttributeMetaData("number of qualified employees", null, 3, new Range(1.0, 10.0)));
        emd.addAttribute(new AttributeMetaData("leader changed", null, POSSIBLE_VALUES[3]));
        emd.addAttribute(new AttributeMetaData("average years of experience", null, 3, new Range(1.0, 10.0)));
        emd.addAttribute(new AttributeMetaData("structure", null, POSSIBLE_VALUES[5]));
        emd.setNumberOfExamples(this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES));
        return emd;
    }
}

