/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.generator.ClusterFunction;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.tools.RandomGenerator;
import java.util.HashSet;
import java.util.Set;

public class SpiralClusteringFunction
extends ClusterFunction {
    private static final int NUMBER_OF_TURNS = 3;
    private static final double ANGLE_OFFSET = 4.71238898038469;
    private static final double ANGLE_FACTOR = Math.PI * 2;
    private static final double RADIUS_OFFSET = 2.0;
    private double bound = 10.0;
    private int currentNumber = 0;
    private double currentPhi = 0.0;
    private double deltaPhi;
    private double currentRadiusOffset = 0.0;
    private double currentLabel;
    Attribute label = AttributeFactory.createAttribute("label", 1);

    public SpiralClusteringFunction() {
        this.label.getMapping().mapString("spiral1");
        this.label.getMapping().mapString("spiral2");
    }

    @Override
    public void init(RandomGenerator random) {
        this.currentPhi = 4.71238898038469;
        this.deltaPhi = 14.137166941154069 / ((double)this.numberOfExamples / 2.0);
        this.currentNumber = 0;
        this.currentRadiusOffset = 0.0;
        this.currentLabel = this.getLabel().getMapping().mapString("spiral1");
    }

    @Override
    public Attribute getLabel() {
        return this.label;
    }

    @Override
    public double calculate(double[] att) throws TargetFunction.FunctionException {
        return this.currentLabel;
    }

    @Override
    public double[] createArguments(int number, RandomGenerator random) throws TargetFunction.FunctionException {
        if (number != 2) {
            throw new TargetFunction.FunctionException("Ring clustering function", "must have 2 attributes!");
        }
        double[] args = new double[number];
        if (this.currentNumber == this.numberOfExamples / 2) {
            this.currentPhi = 4.71238898038469;
            this.currentRadiusOffset = 2.0;
            this.currentLabel = this.getLabel().getMapping().mapString("spiral2");
        }
        this.currentPhi += this.deltaPhi;
        double r = this.bound * this.currentPhi / 14.137166941154069 - this.currentRadiusOffset;
        args[0] = Math.cos(this.currentPhi) * r + random.nextGaussian() * 0.1;
        args[1] = Math.sin(this.currentPhi) * r + random.nextGaussian() * 0.1;
        ++this.currentNumber;
        return args;
    }

    @Override
    protected Set<String> getClusterSet() {
        HashSet<String> clusters = new HashSet<String>();
        clusters.add("spiral1");
        clusters.add("spiral2");
        return clusters;
    }
}

