/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.container.Range;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public class SalesExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    private static final int MAX_STORES = 15;
    private static final int MAX_CUSTOMERS = 2000;
    private static final String[] ATTRIBUTE_NAMES = new String[]{"transaction_id", "store_id", "customer_id", "product_id", "product_category", "date", "amount", "single_price"};
    private static final int ATT_TRANSACTION_ID = 0;
    private static final int ATT_STORE_ID = 1;
    private static final int ATT_CUSTOMER_ID = 2;
    private static final int ATT_PRODUCT_ID = 3;
    private static final int ATT_PRODUCT_CATEGORY = 4;
    private static final int ATT_DATE = 5;
    private static final int ATT_AMOUNT = 6;
    private static final int ATT_SINGLE_PRICE = 7;
    private static final String[] PRODUCT_CATEGORIES = new String[]{"Books", "Movies", "Electronics", "Home/Garden", "Health", "Toys", "Sports", "Clothing"};

    public SalesExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute transactionId = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[0], 3);
        attributes.add(transactionId);
        Attribute storeId = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[1], 1);
        for (int s = 1; s <= 15; ++s) {
            storeId.getMapping().mapString("Store " + this.getFullStoreNumber(s));
        }
        attributes.add(storeId);
        Attribute customerId = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[2], 1);
        for (int s = 1; s <= 2000; ++s) {
            customerId.getMapping().mapString("Customer " + s);
        }
        attributes.add(customerId);
        attributes.add(AttributeFactory.createAttribute(ATTRIBUTE_NAMES[3], 3));
        Attribute productCategory = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[4], 1);
        for (int s = 0; s < PRODUCT_CATEGORIES.length; ++s) {
            productCategory.getMapping().mapString(PRODUCT_CATEGORIES[s]);
        }
        attributes.add(productCategory);
        attributes.add(AttributeFactory.createAttribute(ATTRIBUTE_NAMES[5], 10));
        attributes.add(AttributeFactory.createAttribute(ATTRIBUTE_NAMES[6], 3));
        attributes.add(AttributeFactory.createAttribute(ATTRIBUTE_NAMES[7], 4));
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        for (int n = 0; n < numberOfExamples; ++n) {
            double[] values = new double[ATTRIBUTE_NAMES.length];
            values[0] = n + 1;
            values[1] = ((Attribute)attributes.get(1)).getMapping().mapString("Store " + this.getFullStoreNumber(random.nextIntInRange(1, 16)));
            values[2] = ((Attribute)attributes.get(2)).getMapping().mapString("Customer " + random.nextIntInRange(1, 2001));
            values[3] = random.nextIntInRange(10000, 100000);
            values[4] = random.nextInt(PRODUCT_CATEGORIES.length);
            values[5] = random.nextDateInRange(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2008, 10, 30).getTime()).getTime();
            values[6] = random.nextIntInRange(1, 10);
            values[7] = random.nextDoubleInRange(10.0, 100.0);
            table.addDataRow(new DoubleArrayDataRow(values));
        }
        return table.createExampleSet(null, null, transactionId);
    }

    private String getFullStoreNumber(int number) {
        if (number < 10) {
            return "0" + number;
        }
        return number + "";
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        ExampleSetMetaData emd = new ExampleSetMetaData();
        emd.addAttribute(new AttributeMetaData("transaction_id", 3, "id"));
        emd.addAttribute(new AttributeMetaData("store_id", null, "Store 01", "Store 02", "Store 03", "Store 04", "Store 05", "Store 06", "Store 07", "Store 08", "Store 09", "Store 10", "Store 11", "Store 12", "Store 13", "Store 14", "Store 15"));
        String[] customers = new String[2000];
        for (int i = 0; i < 2000; ++i) {
            customers[i] = "Customer " + (i + 1);
        }
        emd.addAttribute(new AttributeMetaData("customer_id", null, customers));
        emd.addAttribute(new AttributeMetaData("product_id", null, 3, new Range(10000.0, 100000.0)));
        emd.addAttribute(new AttributeMetaData("product_category", null, PRODUCT_CATEGORIES));
        emd.addAttribute(new AttributeMetaData("date", 10));
        emd.addAttribute(new AttributeMetaData("amount", null, 3, new Range(1.0, 10.0)));
        emd.addAttribute(new AttributeMetaData("single_price", null, 3, new Range(10.0, 100.0)));
        emd.setNumberOfExamples(this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES));
        return emd;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

