/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.generator.ClusterFunction;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.tools.RandomGenerator;
import java.util.HashSet;
import java.util.Set;

public class RingClusteringFunction
extends ClusterFunction {
    private double bound = 10.0;
    private Attribute label = AttributeFactory.createAttribute("label", 1);
    private RandomGenerator random;

    public RingClusteringFunction() {
        this.label.getMapping().mapString("core");
        this.label.getMapping().mapString("first_ring");
        this.label.getMapping().mapString("second_ring");
    }

    @Override
    public void init(RandomGenerator random) {
        this.random = random;
    }

    @Override
    public void setLowerArgumentBound(double lower) {
        this.bound = Math.max(this.bound, Math.abs(lower));
    }

    @Override
    public void setUpperArgumentBound(double upper) {
        this.bound = Math.max(this.bound, Math.abs(upper));
    }

    @Override
    public Attribute getLabel() {
        return this.label;
    }

    @Override
    public double calculate(double[] att) throws TargetFunction.FunctionException {
        if (att.length != 2) {
            throw new TargetFunction.FunctionException("Ring clustering function", "must have 2 attributes!");
        }
        if (this.random.nextDouble() < 0.05) {
            int type = this.random.nextInt(3);
            switch (type) {
                case 0: {
                    return this.getLabel().getMapping().mapString("core");
                }
                case 1: {
                    return this.getLabel().getMapping().mapString("first_ring");
                }
                case 2: {
                    return this.getLabel().getMapping().mapString("second_ring");
                }
            }
            return this.getLabel().getMapping().mapString("core");
        }
        double radius = Math.sqrt(att[0] * att[0] + att[1] * att[1]);
        if (radius < this.bound / 3.0) {
            return this.getLabel().getMapping().mapString("core");
        }
        if (radius < 2.0 * this.bound / 3.0) {
            return this.getLabel().getMapping().mapString("first_ring");
        }
        return this.getLabel().getMapping().mapString("second_ring");
    }

    @Override
    public double[] createArguments(int number, RandomGenerator random) throws TargetFunction.FunctionException {
        if (number != 2) {
            throw new TargetFunction.FunctionException("Ring clustering function", "must have 2 attributes!");
        }
        double[] args = new double[number];
        int type = random.nextInt(3);
        double radius = 0.0;
        switch (type) {
            case 0: {
                radius = random.nextGaussian();
                break;
            }
            case 1: {
                radius = this.bound / 2.0 + random.nextGaussian();
                break;
            }
            case 2: {
                radius = this.bound + random.nextGaussian();
                break;
            }
            default: {
                radius = random.nextGaussian();
            }
        }
        double angle = random.nextDouble() * 2.0 * Math.PI;
        args[0] = radius * Math.cos(angle);
        args[1] = radius * Math.sin(angle);
        return args;
    }

    @Override
    protected Set<String> getClusterSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("core");
        set.add("first_ring");
        set.add("second_ring");
        return set;
    }
}

