/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.container.Range;

public abstract class RegressionFunction
implements TargetFunction {
    private double lower = -10.0;
    private double upper = 10.0;
    protected int numberOfExamples = 0;
    protected int numberOfAttributes = 0;

    @Override
    public void init(RandomGenerator random) {
    }

    @Override
    public void setLowerArgumentBound(double lower) {
        this.lower = lower;
    }

    @Override
    public void setUpperArgumentBound(double upper) {
        this.upper = upper;
    }

    @Override
    public void setTotalNumberOfExamples(int number) {
        this.numberOfExamples = number;
    }

    @Override
    public void setTotalNumberOfAttributes(int number) {
        this.numberOfAttributes = number;
    }

    @Override
    public Attribute getLabel() {
        return AttributeFactory.createAttribute("label", 4);
    }

    @Override
    public double[] createArguments(int dimension, RandomGenerator random) throws TargetFunction.FunctionException {
        double[] args = new double[dimension];
        for (int i = 0; i < args.length; ++i) {
            args[i] = random.nextDoubleInRange(this.lower, this.upper);
        }
        return args;
    }

    @Override
    public ExampleSetMetaData getGeneratedMetaData() {
        ExampleSetMetaData emd = new ExampleSetMetaData();
        AttributeMetaData amd = new AttributeMetaData("label", 4, "label");
        amd.setValueRange(new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), SetRelation.SUBSET);
        emd.addAttribute(amd);
        for (int i = 0; i < this.numberOfAttributes; ++i) {
            amd = new AttributeMetaData("att" + (i + 1), 4);
            amd.setValueRange(new Range(this.lower, this.upper), SetRelation.EQUAL);
            emd.addAttribute(amd);
        }
        emd.setNumberOfExamples(this.numberOfExamples);
        return emd;
    }
}

