/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.operator.generator.ClassificationFunction;
import com.rapidminer.operator.generator.Dot;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.tools.RandomGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RandomDotsClassificationFunction
extends ClassificationFunction {
    private static final int NUMBER_OF_POSITIVE_DOTS = 10;
    private static final int NUMBER_OF_NEGATIVE_DOTS = 5;
    private List<Dot> positiveDots = new LinkedList<Dot>();
    private List<Dot> negativeDots = new LinkedList<Dot>();

    @Override
    public void init(RandomGenerator random) {
        int i;
        this.positiveDots.clear();
        this.negativeDots.clear();
        double maxRadius = (this.upper - this.lower) / 10.0;
        for (i = 0; i < 10; ++i) {
            this.positiveDots.add(new Dot(random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(0.0, maxRadius)));
        }
        for (i = 0; i < 5; ++i) {
            this.negativeDots.add(new Dot(random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(0.0, maxRadius)));
        }
    }

    @Override
    public double calculate(double[] att) throws TargetFunction.FunctionException {
        if (att.length != 2) {
            throw new TargetFunction.FunctionException("Random Dot classification function", "needs 2 attributes!");
        }
        for (Dot pDot : this.positiveDots) {
            if (!pDot.contains(att[0], att[1])) continue;
            Iterator<Dot> n = this.negativeDots.iterator();
            boolean negative = false;
            while (n.hasNext()) {
                Dot nDot = n.next();
                if (!nDot.contains(att[0], att[1])) continue;
                negative = true;
                break;
            }
            if (negative) {
                return this.getLabel().getMapping().mapString("negative");
            }
            return this.getLabel().getMapping().mapString("positive");
        }
        return this.getLabel().getMapping().mapString("negative");
    }
}

