/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

public class NominalExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    public static final String PARAMETER_NUMBER_OF_ATTRIBUTES = "number_of_attributes";
    public static final String PARAMETER_NUMBER_OF_VALUES = "number_of_values";

    public NominalExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        int numberOfAttributes = this.getParameterAsInt(PARAMETER_NUMBER_OF_ATTRIBUTES);
        int numberOfValues = this.getParameterAsInt(PARAMETER_NUMBER_OF_VALUES);
        if (numberOfValues < 2) {
            this.logWarning("Less than 2 different values used, change to '2'.");
            numberOfValues = 2;
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (int m = 0; m < numberOfAttributes; ++m) {
            Attribute current = AttributeFactory.createAttribute("att" + (m + 1), 1);
            for (int v = 0; v < numberOfValues; ++v) {
                current.getMapping().mapString("value" + v);
            }
            attributes.add(current);
        }
        Attribute label = AttributeFactory.createAttribute("label", 1);
        label.getMapping().mapString("negative");
        label.getMapping().mapString("positive");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        for (int n = 0; n < numberOfExamples; ++n) {
            double[] features = new double[numberOfAttributes];
            for (int a = 0; a < features.length; ++a) {
                features[a] = random.nextIntInRange(0, numberOfValues);
            }
            double[] example = features;
            if (label != null) {
                example = new double[numberOfAttributes + 1];
                System.arraycopy(features, 0, example, 0, features.length);
                example[example.length - 1] = features.length >= 2 ? (features[0] == 0.0 || features[1] == 0.0 ? (double)label.getMapping().mapString("positive") : (double)label.getMapping().mapString("negative")) : (features.length == 1 ? (features[0] == 0.0 ? (double)label.getMapping().mapString("positive") : (double)label.getMapping().mapString("negative")) : (double)label.getMapping().mapString("positive"));
            }
            table.addDataRow(new DoubleArrayDataRow(example));
        }
        return table.createExampleSet(label);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_ATTRIBUTES, "The number of attributes.", 0, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_VALUES, "The number of nominal values for each attribute.", 0, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        int i;
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        int numberOfAttributes = this.getParameterAsInt(PARAMETER_NUMBER_OF_ATTRIBUTES);
        int numberOfValues = this.getParameterAsInt(PARAMETER_NUMBER_OF_VALUES);
        ExampleSetMetaData emd = new ExampleSetMetaData();
        emd.addAttribute(new AttributeMetaData("label", "label", "positive", "negative"));
        String[] values = new String[numberOfValues];
        for (i = 0; i < numberOfValues; ++i) {
            values[i] = "value" + i;
        }
        for (i = 0; i < numberOfAttributes; ++i) {
            emd.addAttribute(new AttributeMetaData("att" + (i + 1), null, values));
        }
        emd.setNumberOfExamples(numberOfExamples);
        return emd;
    }
}

