/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.generator.ClassificationFunction;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.math.container.Range;
import java.util.HashSet;

public class MultiClassificationFunction
extends ClassificationFunction {
    Attribute nominalLabel = AttributeFactory.createAttribute("label", 1);

    public MultiClassificationFunction() {
        this.getLabel().getMapping().mapString("one");
        this.getLabel().getMapping().mapString("two");
        this.getLabel().getMapping().mapString("three");
        this.getLabel().getMapping().mapString("four");
    }

    @Override
    public Attribute getLabel() {
        return this.nominalLabel;
    }

    @Override
    public double calculate(double[] args) throws TargetFunction.FunctionException {
        double sumD = 0.0;
        for (int i = 0; i < args.length; ++i) {
            sumD += args[i];
        }
        int sum = Math.abs((int)Math.round(sumD));
        if (sum % 2 == 0) {
            return this.getLabel().getMapping().mapString("one");
        }
        if (sum % 3 == 0) {
            return this.getLabel().getMapping().mapString("two");
        }
        if (sum % 5 == 0) {
            return this.getLabel().getMapping().mapString("three");
        }
        return this.getLabel().getMapping().mapString("four");
    }

    @Override
    public ExampleSetMetaData getGeneratedMetaData() {
        ExampleSetMetaData emd = new ExampleSetMetaData();
        AttributeMetaData amd = new AttributeMetaData("label", 1, "label");
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.add("one");
        valueSet.add("two");
        valueSet.add("three");
        valueSet.add("four");
        amd.setValueSet(valueSet, SetRelation.EQUAL);
        emd.addAttribute(amd);
        for (int i = 0; i < this.getTotalNumberOfAttributes(); ++i) {
            amd = new AttributeMetaData("att" + (i + 1), 4);
            amd.setValueRange(new Range(this.lower, this.upper), SetRelation.EQUAL);
            emd.addAttribute(amd);
        }
        emd.setNumberOfExamples(this.getTotalNumberOfExamples());
        return emd;
    }
}

