/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.generator.RegressionFunction;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.tools.RandomGenerator;

public class GridFunction
extends RegressionFunction {
    private double lowerBound = -10.0;
    private double upperBound = 10.0;
    private int[] counter;
    private int maxCounter;
    private double dimDistance;

    @Override
    public void init(RandomGenerator random) {
        this.counter = new int[this.numberOfAttributes];
        this.maxCounter = (int)Math.round(Math.exp(Math.log(this.numberOfExamples) / (double)this.numberOfAttributes));
        this.dimDistance = (this.upperBound - this.lowerBound) / (double)this.maxCounter;
    }

    @Override
    public Attribute getLabel() {
        return AttributeFactory.createAttribute("label", 4);
    }

    @Override
    public double calculate(double[] att) throws TargetFunction.FunctionException {
        return 0.0;
    }

    @Override
    public double[] createArguments(int number, RandomGenerator random) throws TargetFunction.FunctionException {
        if (number <= 0) {
            throw new TargetFunction.FunctionException("Grid function", "must have at least one attribute!");
        }
        double[] args = new double[number];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.lowerBound + this.dimDistance / 2.0 + (double)this.counter[i] * this.dimDistance;
        }
        this.incrementCounter(this.counter, 0);
        return args;
    }

    private void incrementCounter(int[] counter, int pos) {
        int n = pos;
        counter[n] = counter[n] + 1;
        if (counter[pos] >= this.maxCounter) {
            counter[pos] = 0;
            if (pos < counter.length - 1) {
                this.incrementCounter(counter, pos + 1);
            }
        }
    }
}

