/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.generator.Cluster;
import com.rapidminer.operator.generator.ClusterFunction;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.tools.RandomGenerator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GaussianMixtureFunction
extends ClusterFunction {
    private static int CLUSTER_PER_DIMENSION = 2;
    private List<Cluster> clusters = new LinkedList<Cluster>();
    Attribute label = AttributeFactory.createAttribute("label", 1);
    private double currentLabel;

    @Override
    public void init(RandomGenerator random) {
        this.clusters.clear();
        double sizeSum = 0.0;
        int numberOfClusters = (int)Math.pow(CLUSTER_PER_DIMENSION, this.numberOfAttributes);
        for (int i = 0; i < numberOfClusters; ++i) {
            double[] coordinates = new double[this.numberOfAttributes];
            double[] sigmas = new double[this.numberOfAttributes];
            for (int j = 0; j < coordinates.length; ++j) {
                coordinates[j] = random.nextDoubleInRange(this.lowerBound, this.upperBound);
                sigmas[j] = random.nextDouble() * 0.8 + 0.2;
            }
            int labelIndex = this.label.getMapping().mapString("cluster" + i);
            double size = random.nextDouble();
            sizeSum += size;
            this.clusters.add(new Cluster(coordinates, sigmas, size, labelIndex));
        }
        for (Cluster cluster : this.clusters) {
            cluster.size /= sizeSum;
        }
    }

    @Override
    public Attribute getLabel() {
        return this.label;
    }

    @Override
    public double calculate(double[] att) throws TargetFunction.FunctionException {
        return this.currentLabel;
    }

    @Override
    public double[] createArguments(int number, RandomGenerator random) throws TargetFunction.FunctionException {
        if (number <= 0) {
            throw new TargetFunction.FunctionException("Gaussian mixture clustering function", "must have at least one attribute!");
        }
        int c = 0;
        double prob = random.nextDouble();
        double sizeSum = 0.0;
        Cluster cluster = null;
        do {
            cluster = this.clusters.get(c);
            if (prob < (sizeSum += cluster.size)) break;
            ++c;
        } while (sizeSum < 1.0);
        this.currentLabel = cluster.label;
        return cluster.createArguments(random);
    }

    @Override
    protected Set<String> getClusterSet() {
        HashSet<String> set = new HashSet<String>();
        int numberOfClusters = (int)Math.pow(CLUSTER_PER_DIMENSION, this.numberOfAttributes);
        for (int i = 0; i < numberOfClusters; ++i) {
            set.add("cluster" + i);
        }
        return set;
    }
}

