/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.generator.RegressionFunction;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.tools.RandomGenerator;

public class GaussianFunction
extends RegressionFunction {
    private double bound = 10.0;

    @Override
    public void setLowerArgumentBound(double lower) {
        this.bound = Math.max(this.bound, Math.abs(lower));
    }

    @Override
    public void setUpperArgumentBound(double upper) {
        this.bound = Math.max(this.bound, Math.abs(upper));
    }

    @Override
    public Attribute getLabel() {
        return AttributeFactory.createAttribute("label", 4);
    }

    @Override
    public double calculate(double[] att) throws TargetFunction.FunctionException {
        return 0.0;
    }

    @Override
    public double[] createArguments(int number, RandomGenerator random) {
        double[] args = new double[number];
        for (int i = 0; i < args.length; ++i) {
            args[i] = random.nextGaussian() * this.bound;
        }
        return args;
    }
}

