/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.generator.CheckerboardClassificationFunction;
import com.rapidminer.operator.generator.ComplicatedFunction;
import com.rapidminer.operator.generator.ComplicatedFunction2;
import com.rapidminer.operator.generator.DrillerOscillationFunction;
import com.rapidminer.operator.generator.GaussianFunction;
import com.rapidminer.operator.generator.GaussianMixtureFunction;
import com.rapidminer.operator.generator.GlobalAndLocalPatternsFunction;
import com.rapidminer.operator.generator.GridFunction;
import com.rapidminer.operator.generator.InteractionClassificationFunction;
import com.rapidminer.operator.generator.MultiClassificationFunction;
import com.rapidminer.operator.generator.NonLinearFunction;
import com.rapidminer.operator.generator.OneThirdClassification;
import com.rapidminer.operator.generator.OneVariableNonLinearFunction;
import com.rapidminer.operator.generator.PolynomialClassificationFunction;
import com.rapidminer.operator.generator.PolynomialFunction;
import com.rapidminer.operator.generator.QuadraticClassificationFunction;
import com.rapidminer.operator.generator.RandomClassificationFunction;
import com.rapidminer.operator.generator.RandomDotsClassificationFunction;
import com.rapidminer.operator.generator.RandomFunction;
import com.rapidminer.operator.generator.RingClusteringFunction;
import com.rapidminer.operator.generator.SimpleNonLinearClassificationFunction;
import com.rapidminer.operator.generator.SimplePolynomialClassificationFunction;
import com.rapidminer.operator.generator.SimpleSinusFunction;
import com.rapidminer.operator.generator.SimpleSuperpositionFunction;
import com.rapidminer.operator.generator.SincFunction;
import com.rapidminer.operator.generator.SinusClassificationFunction;
import com.rapidminer.operator.generator.SinusFrequencyFunction;
import com.rapidminer.operator.generator.SinusFunction;
import com.rapidminer.operator.generator.SinusWithTrendFunction;
import com.rapidminer.operator.generator.SpiralClusteringFunction;
import com.rapidminer.operator.generator.SquarePulseFunction;
import com.rapidminer.operator.generator.SumClassificationFunction;
import com.rapidminer.operator.generator.SumFunction;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.operator.generator.TransactionDatasetFunction;
import com.rapidminer.operator.generator.TriangularFunction;
import com.rapidminer.operator.generator.TwoGaussiansClassificationFunction;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_TARGET_FUNCTION = "target_function";
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    public static final String PARAMETER_NUMBER_OF_ATTRIBUTES = "number_of_attributes";
    public static final String PARAMETER_ATTRIBUTES_LOWER_BOUND = "attributes_lower_bound";
    public static final String PARAMETER_ATTRIBUTES_UPPER_BOUND = "attributes_upper_bound";
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";
    private static final String[] KNOWN_FUNCTION_NAMES = new String[]{"random", "sum", "polynomial", "non linear", "one variable non linear", "complicated function", "complicated function2", "simple sinus", "sinus", "simple superposition", "sinus frequency", "sinus with trend", "sinc", "triangular function", "square pulse function", "random classification", "one third classification", "sum classification", "quadratic classification", "simple non linear classification", "interaction classification", "simple polynomial classification", "polynomial classification", "checkerboard classification", "random dots classification", "global and local models classification", "sinus classification", "multi classification", "two gaussians classification", "transactions dataset", "grid function", "three ring clusters", "spiral cluster", "single gaussian cluster", "gaussian mixture clusters", "driller oscillation timeseries"};
    private static final Class[] KNOWN_FUNCTION_IMPLEMENTATIONS = new Class[]{RandomFunction.class, SumFunction.class, PolynomialFunction.class, NonLinearFunction.class, OneVariableNonLinearFunction.class, ComplicatedFunction.class, ComplicatedFunction2.class, SimpleSinusFunction.class, SinusFunction.class, SimpleSuperpositionFunction.class, SinusFrequencyFunction.class, SinusWithTrendFunction.class, SincFunction.class, TriangularFunction.class, SquarePulseFunction.class, RandomClassificationFunction.class, OneThirdClassification.class, SumClassificationFunction.class, QuadraticClassificationFunction.class, SimpleNonLinearClassificationFunction.class, InteractionClassificationFunction.class, SimplePolynomialClassificationFunction.class, PolynomialClassificationFunction.class, CheckerboardClassificationFunction.class, RandomDotsClassificationFunction.class, GlobalAndLocalPatternsFunction.class, SinusClassificationFunction.class, MultiClassificationFunction.class, TwoGaussiansClassificationFunction.class, TransactionDatasetFunction.class, GridFunction.class, RingClusteringFunction.class, SpiralClusteringFunction.class, GaussianFunction.class, GaussianMixtureFunction.class, DrillerOscillationFunction.class};

    public ExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        TargetFunction function = this.createTargetFunction();
        ExampleSetMetaData generatedMD = function.getGeneratedMetaData();
        return generatedMD;
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        int numberOfAttributes = this.getParameterAsInt(PARAMETER_NUMBER_OF_ATTRIBUTES);
        TargetFunction function = this.createTargetFunction();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int m = 0; m < numberOfAttributes; ++m) {
            attributes.add(AttributeFactory.createAttribute("att" + (m + 1), 4));
        }
        Attribute label = function.getLabel();
        if (label != null) {
            attributes.add(label);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        LinkedList<DataRow> data = new LinkedList<DataRow>();
        DataRowFactory factory = new DataRowFactory(this.getParameterAsInt(PARAMETER_DATAMANAGEMENT), '.');
        try {
            function.init(random);
            for (int n = 0; n < numberOfExamples; ++n) {
                double[] features;
                double[] example = features = function.createArguments(numberOfAttributes, random);
                if (label != null) {
                    example = new double[numberOfAttributes + 1];
                    System.arraycopy(features, 0, example, 0, features.length);
                    example[example.length - 1] = function.calculate(features);
                }
                DataRow row = factory.create(example.length);
                for (int i = 0; i < example.length; ++i) {
                    row.set((Attribute)attributes.get(i), example[i]);
                }
                row.trim();
                data.add(row);
            }
        }
        catch (TargetFunction.FunctionException e) {
            throw new UserError((Operator)this, 918, e.getFunctionName(), e.getMessage());
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        ExampleSet result = table.createExampleSet(label);
        return result;
    }

    private TargetFunction createTargetFunction() throws UndefinedParameterError, UserError {
        String functionName = this.getParameterAsString(PARAMETER_TARGET_FUNCTION);
        if (functionName == null) {
            throw new UserError((Operator)this, 205, PARAMETER_TARGET_FUNCTION);
        }
        TargetFunction function = null;
        try {
            function = ExampleSetGenerator.getFunctionForName(functionName);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, functionName, e);
        }
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        int numberOfAttributes = this.getParameterAsInt(PARAMETER_NUMBER_OF_ATTRIBUTES);
        double lower = this.getParameterAsDouble(PARAMETER_ATTRIBUTES_LOWER_BOUND);
        double upper = this.getParameterAsDouble(PARAMETER_ATTRIBUTES_UPPER_BOUND);
        function.setLowerArgumentBound(lower);
        function.setUpperArgumentBound(upper);
        function.setTotalNumberOfExamples(numberOfExamples);
        function.setTotalNumberOfAttributes(numberOfAttributes);
        return function;
    }

    public static TargetFunction getFunctionForName(String functionName) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        for (int i = 0; i < KNOWN_FUNCTION_NAMES.length; ++i) {
            if (!KNOWN_FUNCTION_NAMES[i].equals(functionName)) continue;
            return (TargetFunction)KNOWN_FUNCTION_IMPLEMENTATIONS[i].newInstance();
        }
        Class clazz = Tools.classForName(functionName);
        return (TargetFunction)clazz.newInstance();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory(PARAMETER_TARGET_FUNCTION, "Specifies the target function of this example set", KNOWN_FUNCTION_NAMES, KNOWN_FUNCTION_NAMES[0]);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_ATTRIBUTES, "The number of attributes.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_ATTRIBUTES_LOWER_BOUND, "The minimum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -10.0));
        types.add(new ParameterTypeDouble(PARAMETER_ATTRIBUTES_UPPER_BOUND, "The maximum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 10.0));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        types.add(new ParameterTypeCategory(PARAMETER_DATAMANAGEMENT, "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }
}

