/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.container.Range;

public class DrillerOscillationFunction
implements TargetFunction {
    private static final double SKEW_CATASTROPHY_EXPONENT = 1.2;
    private double TURN_PERIODS = 16.0;
    private static double GENERAL_NOISE = 0.02;
    private static double INITIAL_SKEW_RATE_VARIANCE = 0.2;
    private static double LAST_SKEW_CHANGE_PROBABILITY = 0.2;
    private static double MAXIMAL_SKEW_CHANGE = 0.1;
    private static double CRITICAL_FREQUENCY_SKEW = 2.7;
    private static double SKEW_FASTER_PREFERENCE = 0.3;
    private int periodLength;
    private int period = 0;
    private double[] frequencePeriod;
    private double[] skew;
    private double[] skewChangeDirection;
    private double[] crashed;
    private int numberOfAttributes;
    private int numberOfExamples;

    @Override
    public double calculate(double[] args) throws TargetFunction.FunctionException {
        return 0.0;
    }

    @Override
    public double[] createArguments(int dimension, RandomGenerator random) throws TargetFunction.FunctionException {
        int i;
        if (this.skew == null) {
            int i2;
            this.skew = new double[dimension - 1];
            for (i2 = 0; i2 < dimension - 1; ++i2) {
                this.skew[i2] = 1.0 + random.nextDoubleInRange(-INITIAL_SKEW_RATE_VARIANCE, INITIAL_SKEW_RATE_VARIANCE);
            }
            this.skewChangeDirection = new double[dimension - 1];
            for (i2 = 0; i2 < dimension - 1; ++i2) {
                this.skewChangeDirection[i2] = random.nextDouble() - SKEW_FASTER_PREFERENCE;
            }
            this.crashed = new double[dimension];
            this.frequencePeriod = new double[dimension - 1];
        }
        double[] values = new double[dimension];
        --dimension;
        double neededProbability = Math.pow((double)this.period / (double)this.periodLength, 1.5) * LAST_SKEW_CHANGE_PROBABILITY;
        for (i = 0; i < dimension; ++i) {
            if (this.skew[i] > CRITICAL_FREQUENCY_SKEW) {
                this.skew[i] = Math.pow(this.skew[i], 1.2);
                this.crashed[i] = 1.0;
                continue;
            }
            double dice = random.nextDouble();
            if (!(dice <= neededProbability)) continue;
            double skewChange = this.skew[i] * random.nextDoubleInRange(0.0, MAXIMAL_SKEW_CHANGE);
            this.skew[i] = random.nextDouble() <= this.skewChangeDirection[i] ? this.skew[i] - skewChange : this.skew[i] + skewChange;
        }
        for (i = 0; i < dimension; ++i) {
            this.frequencePeriod[i] = this.frequencePeriod[i] + Math.PI * this.skew[i] / this.TURN_PERIODS;
            values[i] = Math.sin(this.frequencePeriod[i]);
            values[i] = values[i] * random.nextDoubleInRange(1.0 - GENERAL_NOISE, 1.0 + GENERAL_NOISE);
        }
        values[1] = this.skew[0];
        values[dimension] = this.period;
        ++this.period;
        if (this.period == this.periodLength) {
            this.crashed[dimension] = this.period;
            return this.crashed;
        }
        return values;
    }

    @Override
    public Attribute getLabel() {
        return null;
    }

    @Override
    public void init(RandomGenerator random) {
    }

    @Override
    public void setUpperArgumentBound(double upper) {
    }

    @Override
    public void setLowerArgumentBound(double lower) {
    }

    @Override
    public void setTotalNumberOfAttributes(int number) {
        this.numberOfAttributes = number;
    }

    @Override
    public void setTotalNumberOfExamples(int number) {
        this.periodLength = number;
        this.numberOfExamples = number;
    }

    @Override
    public ExampleSetMetaData getGeneratedMetaData() {
        ExampleSetMetaData emd = new ExampleSetMetaData();
        for (int i = 1; i <= this.numberOfAttributes; ++i) {
            AttributeMetaData amd = new AttributeMetaData("att" + i, 4);
            amd.setValueRange(new Range(-1.0 - GENERAL_NOISE, 1.0 + GENERAL_NOISE), SetRelation.EQUAL);
        }
        emd.setNumberOfExamples(this.numberOfExamples);
        return emd;
    }
}

