/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.container.Range;
import java.util.ArrayList;
import java.util.List;

public class DirectMailingExampleSetGenerator
extends AbstractExampleSource {
    public static final String PARAMETER_NUMBER_EXAMPLES = "number_examples";
    private static String[] ATTRIBUTE_NAMES = new String[]{"name", "age", "lifestyle", "zip code", "family status", "car", "sports", "earnings"};
    private static int[] VALUE_TYPES = new int[]{1, 3, 1, 3, 1, 1, 1, 3};
    private static String[][] POSSIBLE_VALUES = new String[][]{null, null, {"healthy", "active", "cozily"}, null, {"married", "single"}, {"practical", "expensive"}, {"soccer", "badminton", "athletics"}, null};

    public DirectMailingExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int m = 0; m < ATTRIBUTE_NAMES.length; ++m) {
            Attribute current = AttributeFactory.createAttribute(ATTRIBUTE_NAMES[m], VALUE_TYPES[m]);
            String[] possibleValues = POSSIBLE_VALUES[m];
            if (possibleValues != null) {
                for (int v = 0; v < possibleValues.length; ++v) {
                    current.getMapping().mapString(possibleValues[v]);
                }
            }
            attributes.add(current);
        }
        Attribute label = AttributeFactory.createAttribute("label", 1);
        label.getMapping().mapString("no response");
        label.getMapping().mapString("response");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        for (int n = 0; n < numberOfExamples; ++n) {
            double[] values = new double[ATTRIBUTE_NAMES.length + 1];
            values[0] = ((Attribute)attributes.get(0)).getMapping().mapString(random.nextString(8));
            values[1] = random.nextIntInRange(15, 70);
            values[2] = random.nextInt(POSSIBLE_VALUES[2].length);
            values[3] = random.nextIntInRange(10000, 100000);
            values[4] = random.nextInt(POSSIBLE_VALUES[4].length);
            values[5] = random.nextInt(POSSIBLE_VALUES[5].length);
            values[6] = random.nextInt(POSSIBLE_VALUES[6].length);
            values[7] = random.nextIntInRange(20000, 150000);
            values[8] = label.getMapping().mapString("no response");
            if (values[1] > 65.0) {
                if (random.nextDouble() > 0.05) {
                    values[8] = label.getMapping().mapString("response");
                }
            } else if (values[1] > 60.0) {
                if (random.nextDouble() > 0.1) {
                    values[8] = label.getMapping().mapString("response");
                }
            } else if (values[1] > 55.0) {
                if (random.nextDouble() > 0.2) {
                    values[8] = label.getMapping().mapString("response");
                }
            } else if (values[3] < 15000.0) {
                if (random.nextDouble() > 0.1) {
                    values[8] = label.getMapping().mapString("response");
                }
            } else if (values[7] > 140000.0) {
                values[8] = label.getMapping().mapString("response");
            }
            table.addDataRow(new DoubleArrayDataRow(values));
        }
        return table.createExampleSet(label);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_EXAMPLES, "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        ExampleSetMetaData emd = new ExampleSetMetaData();
        emd.addAttribute(new AttributeMetaData("label", "label", "response", "no response"));
        emd.addAttribute(new AttributeMetaData("name", 1));
        emd.addAttribute(new AttributeMetaData("age", null, 3, new Range(15.0, 70.0)));
        emd.addAttribute(new AttributeMetaData("lifestyle", null, POSSIBLE_VALUES[2]));
        emd.addAttribute(new AttributeMetaData("zip code", null, 3, new Range(10000.0, 100000.0)));
        emd.addAttribute(new AttributeMetaData("family status", null, POSSIBLE_VALUES[4]));
        emd.addAttribute(new AttributeMetaData("car", null, POSSIBLE_VALUES[5]));
        emd.addAttribute(new AttributeMetaData("sports", null, POSSIBLE_VALUES[6]));
        emd.addAttribute(new AttributeMetaData("earnings", null, 3, new Range(20000.0, 150000.0)));
        emd.setNumberOfExamples(this.getParameterAsInt(PARAMETER_NUMBER_EXAMPLES));
        return emd;
    }
}

