/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.math.container.Range;
import java.util.Set;

public abstract class ClusterFunction
implements TargetFunction {
    protected int numberOfAttributes = 2;
    protected int numberOfExamples = 0;
    protected double lowerBound = -10.0;
    protected double upperBound = 10.0;

    @Override
    public void setLowerArgumentBound(double lower) {
        this.lowerBound = lower;
    }

    @Override
    public void setUpperArgumentBound(double upper) {
        this.upperBound = upper;
    }

    @Override
    public void setTotalNumberOfExamples(int number) {
        this.numberOfExamples = number;
    }

    @Override
    public void setTotalNumberOfAttributes(int number) {
        this.numberOfAttributes = number;
    }

    @Override
    public ExampleSetMetaData getGeneratedMetaData() {
        ExampleSetMetaData emd = new ExampleSetMetaData();
        AttributeMetaData amd = new AttributeMetaData("label", 1, "label");
        amd.setValueSet(this.getClusterSet(), SetRelation.EQUAL);
        emd.addAttribute(amd);
        for (int i = 0; i < this.numberOfAttributes; ++i) {
            amd = new AttributeMetaData("att" + (i + 1), 4);
            amd.setValueRange(new Range(this.lowerBound, this.upperBound), SetRelation.EQUAL);
            emd.addAttribute(amd);
        }
        emd.setNumberOfExamples(this.numberOfExamples);
        return emd;
    }

    protected abstract Set<String> getClusterSet();
}

