/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.container.Range;
import java.util.HashSet;

public abstract class ClassificationFunction
implements TargetFunction {
    protected double lower = -10.0;
    protected double upper = 10.0;
    private int numberOfExamples = 0;
    private int numberOfAttributes = 0;
    Attribute label = AttributeFactory.createAttribute("label", 6);

    public ClassificationFunction() {
        this.label.getMapping().mapString("negative");
        this.label.getMapping().mapString("positive");
    }

    @Override
    public void init(RandomGenerator random) {
    }

    @Override
    public void setTotalNumberOfExamples(int number) {
        this.numberOfExamples = number;
    }

    public int getTotalNumberOfExamples() {
        return this.numberOfExamples;
    }

    @Override
    public void setTotalNumberOfAttributes(int number) {
        this.numberOfAttributes = number;
    }

    public int getTotalNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    @Override
    public void setLowerArgumentBound(double lower) {
        this.lower = lower;
    }

    @Override
    public void setUpperArgumentBound(double upper) {
        this.upper = upper;
    }

    @Override
    public Attribute getLabel() {
        return this.label;
    }

    @Override
    public double[] createArguments(int dimension, RandomGenerator random) {
        double[] args = new double[dimension];
        for (int i = 0; i < args.length; ++i) {
            args[i] = random.nextDoubleInRange(this.lower, this.upper);
        }
        return args;
    }

    @Override
    public ExampleSetMetaData getGeneratedMetaData() {
        ExampleSetMetaData emd = new ExampleSetMetaData();
        AttributeMetaData amd = new AttributeMetaData("label", 6, "label");
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.add("negative");
        valueSet.add("positive");
        amd.setValueSet(valueSet, SetRelation.EQUAL);
        emd.addAttribute(amd);
        for (int i = 0; i < this.numberOfAttributes; ++i) {
            amd = new AttributeMetaData("att" + (i + 1), 4);
            amd.setValueRange(new Range(this.lower, this.upper), SetRelation.EQUAL);
            emd.addAttribute(amd);
        }
        emd.setNumberOfExamples(this.numberOfExamples);
        return emd;
    }
}

