/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.IndividualOperator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class WeightingMutation
extends IndividualOperator {
    private double variance;
    private boolean bounded;
    private Random random;
    private boolean[] isNominal;
    private double nominalMutationProb;

    public WeightingMutation(double variance, boolean bounded, boolean[] isNominal, double nominalMutationProb, Random random) {
        this.variance = variance;
        this.bounded = bounded;
        this.random = random;
        this.isNominal = isNominal;
        this.nominalMutationProb = nominalMutationProb;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public double getVariance() {
        return this.variance;
    }

    @Override
    public List<Individual> operate(Individual individual) {
        double[] weights = individual.getWeightsClone();
        LinkedList<Individual> l = new LinkedList<Individual>();
        for (int i = 0; i < weights.length; ++i) {
            if (!this.isNominal[i]) {
                if (!(this.random.nextDouble() < this.nominalMutationProb)) continue;
                if (weights[i] > 0.0) {
                    weights[i] = 0.0;
                    continue;
                }
                weights[i] = 1.0;
                continue;
            }
            double weight = weights[i] + this.random.nextGaussian() * this.variance;
            if (this.bounded && (!(weight >= 0.0) || !(weight <= 1.0))) continue;
            weights[i] = weight;
        }
        Individual newIndividual = new Individual(weights);
        if (newIndividual.getNumberOfUsedAttributes() > 0) {
            l.add(newIndividual);
        }
        return l;
    }
}

