/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ProcessLog2AttributeWeights
extends Operator {
    public static final String PARAMETER_LOG_NAME = "log_name";
    public static final String PARAMETER_ATTRIBUTE_NAMES_COLUMN = "attribute_names_column";
    public static final String PARAMETER_SORTING_TYPE = "sorting_type";
    public static final String PARAMETER_SORTING_DIMENSION = "sorting_dimension";
    public static final String PARAMETER_SORTING_K = "sorting_k";
    public static final String[] SORTING_TYPES = new String[]{"none", "top-k", "bottom-k"};
    public static final int SORTING_TYPE_NONE = 0;
    public static final int SORTING_TYPE_TOP_K = 1;
    public static final int SORTING_TYPE_BOTTOM_K = 2;
    private OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");

    public ProcessLog2AttributeWeights(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new GenerateNewMDRule(this.weightsOutput, new MetaData(AttributeWeights.class)));
    }

    @Override
    public void doWork() throws OperatorException {
        Collection<DataTable> dataTables = this.getProcess().getDataTables();
        if (dataTables.size() == 0) {
            throw new UserError((Operator)this, 937);
        }
        DataTable dataTable = null;
        if (this.isParameterSet(PARAMETER_LOG_NAME)) {
            String dataTableName = this.getParameterAsString(PARAMETER_LOG_NAME);
            dataTable = this.getProcess().getDataTable(dataTableName);
        } else if (this.getProcess().getDataTables().size() > 0) {
            dataTable = this.getProcess().getDataTables().iterator().next();
            this.logNote("No log name was specified, using first data table found...");
        }
        String attributeNamesColumnName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAMES_COLUMN);
        int attributeNamesIndex = -1;
        int index = 0;
        for (String name : dataTable.getColumnNames()) {
            if (name.equals(attributeNamesColumnName)) {
                attributeNamesIndex = index;
                break;
            }
            ++index;
        }
        if (attributeNamesIndex < 0) {
            throw new UserError((Operator)this, 207, attributeNamesColumnName, PARAMETER_ATTRIBUTE_NAMES_COLUMN, "no column with this name is part of the first found statistics data table");
        }
        String sortingDimensionName = null;
        int sortingK = 0;
        int sortingType = this.getParameterAsInt(PARAMETER_SORTING_TYPE);
        switch (sortingType) {
            case 1: {
                sortingDimensionName = this.getParameterAsString(PARAMETER_SORTING_DIMENSION);
                sortingK = this.getParameterAsInt(PARAMETER_SORTING_K);
                break;
            }
            case 2: {
                sortingDimensionName = this.getParameterAsString(PARAMETER_SORTING_DIMENSION);
                sortingK = this.getParameterAsInt(PARAMETER_SORTING_K);
                break;
            }
        }
        int sortingDimensionIndex = -1;
        if (sortingDimensionName != null) {
            index = 0;
            for (String name : dataTable.getColumnNames()) {
                if (name.equals(sortingDimensionName)) {
                    sortingDimensionIndex = index;
                    break;
                }
                ++index;
            }
            if (sortingDimensionIndex < 0) {
                throw new UserError((Operator)this, 207, sortingDimensionName, PARAMETER_SORTING_DIMENSION, "no column with this name is part of the first found statistics data table");
            }
            if (!dataTable.isNumerical(sortingDimensionIndex)) {
                throw new UserError((Operator)this, 207, sortingDimensionName, PARAMETER_SORTING_DIMENSION, "only numerical columns are allowed for the sorting dimension");
            }
        }
        AttributeWeights weights = this.calculateWeights(dataTable, attributeNamesIndex, sortingType, sortingDimensionIndex, sortingK);
        if (this.getParameterAsBoolean("normalize_weights")) {
            weights.normalize();
        }
        this.weightsOutput.deliver(weights);
    }

    private AttributeWeights calculateWeights(DataTable dataTable, int attributeNamesIndex, final int sortingType, int sortingDimensionIndex, int sortingK) {
        class NamesAndPerformance
        implements Comparable<NamesAndPerformance> {
            String names;
            double performance;

            public NamesAndPerformance(String names, double performance) {
                this.names = names;
                this.performance = performance;
            }

            @Override
            public int compareTo(NamesAndPerformance o) {
                if (sortingType == 0) {
                    return 0;
                }
                if (sortingType == 1) {
                    return Double.compare(o.performance, this.performance);
                }
                return Double.compare(this.performance, o.performance);
            }
        }
        LinkedList<NamesAndPerformance> namesAndPerformances = new LinkedList<NamesAndPerformance>();
        for (int i = 0; i < dataTable.getNumberOfRows(); ++i) {
            DataTableRow row = dataTable.getRow(i);
            String names = dataTable.getValueAsString(row, attributeNamesIndex);
            double performance = 1.0;
            if (sortingDimensionIndex >= 0) {
                performance = row.getValue(sortingDimensionIndex);
            }
            namesAndPerformances.add(new NamesAndPerformance(names, performance));
        }
        Collections.sort(namesAndPerformances);
        HashMap<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
        int number = 0;
        for (NamesAndPerformance namesAndPerformance : namesAndPerformances) {
            String[] names;
            if (sortingType != 0 && number >= sortingK) break;
            for (String name : names = namesAndPerformance.names.split(",")) {
                AtomicInteger counter = (AtomicInteger)counters.get(name = name.trim());
                if (counter == null) {
                    counter = new AtomicInteger(1);
                    counters.put(name, counter);
                    continue;
                }
                counter.incrementAndGet();
            }
            ++number;
        }
        AttributeWeights weights = new AttributeWeights();
        for (Map.Entry entry : counters.entrySet()) {
            String name = (String)entry.getKey();
            int currentCount = ((AtomicInteger)entry.getValue()).intValue();
            weights.setWeight(name, (double)currentCount / (double)number);
        }
        return weights;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("normalize_weights", "Activates the normalization of all weights.", true, false));
        types.add(new ParameterTypeString(PARAMETER_LOG_NAME, "The name of the ProcessLog operator which generated the log data which should be transformed (empty: use first found data table).", true, false));
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAMES_COLUMN, "The column of the statistics (Process Log) containing the attribute names.", false, false));
        types.add(new ParameterTypeCategory(PARAMETER_SORTING_TYPE, "Indicates if the logged values should be sorted according to the specified dimension.", SORTING_TYPES, 0));
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_SORTING_DIMENSION, "If the sorting type is set to top-k or bottom-k, this dimension is used for sorting.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SORTING_TYPE, SORTING_TYPES, true, 1, 2));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SORTING_K, "If the sorting type is set to top-k or bottom-k, this number of results will be kept.", 1, Integer.MAX_VALUE, 100);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SORTING_TYPE, SORTING_TYPES, false, 1, 2));
        types.add(type);
        return types;
    }
}

