/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.optimization.Optimization;
import com.rapidminer.tools.math.optimization.ec.pso.PSOOptimization;
import java.util.List;

public class PSOWeighting
extends OperatorChain {
    public static final String PARAMETER_NORMALIZE_WEIGHTS = "normalize_weights";
    public static final String PARAMETER_POPULATION_SIZE = "population_size";
    public static final String PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS = "maximum_number_of_generations";
    public static final String PARAMETER_USE_EARLY_STOPPING = "use_early_stopping";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_INERTIA_WEIGHT = "inertia_weight";
    public static final String PARAMETER_LOCAL_BEST_WEIGHT = "local_best_weight";
    public static final String PARAMETER_GLOBAL_BEST_WEIGHT = "global_best_weight";
    public static final String PARAMETER_DYNAMIC_INERTIA_WEIGHT = "dynamic_inertia_weight";
    public static final String PARAMETER_MIN_WEIGHT = "min_weight";
    public static final String PARAMETER_MAX_WEIGHT = "max_weight";
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");
    private final InputPort performanceInnerSink = this.getSubprocess(0).getInnerSinks().createPort("performance", PerformanceVector.class);
    private final OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("example set");
    private final PortPairExtender inputExtender = new PortPairExtender("input", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    private Optimization optimization;
    private ExampleSet exampleSet;

    public PSOWeighting(OperatorDescription description) {
        super(description, "Performance Evaluation");
        this.inputExtender.start();
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetInnerSource);
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addPassThroughRule(this.performanceInnerSink, this.performanceOutput);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addRule(new GenerateNewMDRule(this.weightsOutput, AttributeWeights.class));
        this.addValue(new ValueDouble("generation", "The number of the current generation."){

            @Override
            public double getDoubleValue() {
                return PSOWeighting.this.optimization.getGeneration();
            }
        });
        this.addValue(new ValueDouble("performance", "The performance of the current generation (main criterion)."){

            @Override
            public double getDoubleValue() {
                return PSOWeighting.this.optimization.getBestFitnessInGeneration();
            }
        });
        this.addValue(new ValueDouble("best", "The performance of the best individual ever (main criterion)."){

            @Override
            public double getDoubleValue() {
                return PSOWeighting.this.optimization.getBestFitnessEver();
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        this.exampleSet = (ExampleSet)this.exampleSetInput.getData();
        this.optimization = new PSOWeightingOptimization(this, this.exampleSet.getAttributes().size(), RandomGenerator.getRandomGenerator(this));
        this.optimization.optimize();
        double[] globalBestWeights = this.optimization.getBestValuesEver();
        AttributeWeightedExampleSet result = this.createWeightedExampleSet(globalBestWeights);
        AttributeWeights weights = new AttributeWeights();
        int index = 0;
        for (Attribute attribute : result.getAttributes()) {
            weights.setWeight(attribute.getName(), globalBestWeights[index++]);
        }
        if (this.getParameterAsBoolean(PARAMETER_NORMALIZE_WEIGHTS)) {
            weights.normalize();
        }
        this.exampleSetOutput.deliver(this.exampleSet);
        this.weightsOutput.deliver(weights);
        this.performanceOutput.deliver(this.optimization.getBestPerformanceEver());
    }

    private PerformanceVector evaluateIndividual(double[] individual) throws OperatorException {
        boolean onlyZeros = true;
        for (int i = 0; i < individual.length; ++i) {
            if (individual[i] == 0.0) continue;
            onlyZeros = false;
            break;
        }
        if (onlyZeros) {
            return null;
        }
        AttributeWeightedExampleSet evaluationSet = this.createWeightedExampleSet(individual).createCleanClone();
        this.exampleSetInnerSource.deliver(evaluationSet);
        this.inputExtender.passDataThrough();
        this.getSubprocess(0).execute();
        return (PerformanceVector)this.performanceInnerSink.getData();
    }

    private AttributeWeightedExampleSet createWeightedExampleSet(double[] weights) {
        AttributeWeightedExampleSet result = new AttributeWeightedExampleSet(this.exampleSet, null);
        int index = 0;
        for (Attribute attribute : this.exampleSet.getAttributes()) {
            result.setWeight(attribute, weights[index++]);
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_NORMALIZE_WEIGHTS, "Activates the normalization of all weights.", false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_POPULATION_SIZE, "Number of individuals per generation.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS, "Number of generations after which to terminate the algorithm.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_EARLY_STOPPING, "Enables early stopping. If unchecked, always the maximum number of generations is performed.", false));
        type = new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop criterion: Stop after n generations without improval of the performance.", 1, Integer.MAX_VALUE, 2);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EARLY_STOPPING, true, true));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_INERTIA_WEIGHT, "The (initial) weight for the old weighting.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble(PARAMETER_LOCAL_BEST_WEIGHT, "The weight for the individual's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble(PARAMETER_GLOBAL_BEST_WEIGHT, "The weight for the population's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean(PARAMETER_DYNAMIC_INERTIA_WEIGHT, "If set to true the inertia weight is improved during run.", true));
        types.add(new ParameterTypeDouble(PARAMETER_MIN_WEIGHT, "The lower bound for the weights.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_MAX_WEIGHT, "The upper bound for the weights.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    private static class PSOWeightingOptimization
    extends PSOOptimization {
        private final PSOWeighting op;

        public PSOWeightingOptimization(PSOWeighting op, int individualSize, RandomGenerator random) throws UndefinedParameterError {
            super(op.getParameterAsInt(PSOWeighting.PARAMETER_POPULATION_SIZE), individualSize, op.getParameterAsInt(PSOWeighting.PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS), op.getParameterAsBoolean(PSOWeighting.PARAMETER_USE_EARLY_STOPPING) ? op.getParameterAsInt(PSOWeighting.PARAMETER_GENERATIONS_WITHOUT_IMPROVAL) : -1, op.getParameterAsDouble(PSOWeighting.PARAMETER_INERTIA_WEIGHT), op.getParameterAsDouble(PSOWeighting.PARAMETER_LOCAL_BEST_WEIGHT), op.getParameterAsDouble(PSOWeighting.PARAMETER_GLOBAL_BEST_WEIGHT), op.getParameterAsDouble(PSOWeighting.PARAMETER_MIN_WEIGHT), op.getParameterAsDouble(PSOWeighting.PARAMETER_MAX_WEIGHT), op.getParameterAsBoolean(PSOWeighting.PARAMETER_DYNAMIC_INERTIA_WEIGHT), random);
            this.op = op;
        }

        @Override
        public PerformanceVector evaluateIndividual(double[] individual) throws OperatorException {
            return this.op.evaluateIndividual(individual);
        }

        @Override
        public void nextIteration() throws OperatorException {
            super.nextIteration();
            this.op.inApplyLoop();
        }
    }
}

