/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeSelectionExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.rules.SingleRuleLearner;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.performance.SimplePerformanceEvaluator;
import com.rapidminer.tools.OperatorService;

public class OneRErrorWeighting
extends AbstractWeighting {
    public OneRErrorWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    protected AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        SimplePerformanceEvaluator performanceEvaluator;
        AbstractLearner learner;
        Attribute label = exampleSet.getAttributes().getLabel();
        if (!label.isNominal()) {
            throw new UserError((Operator)this, 101, "OneR error weighting", label.getName());
        }
        AttributeWeights weights = new AttributeWeights(exampleSet);
        try {
            learner = OperatorService.createOperator(SingleRuleLearner.class);
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 904, "inner operator", e.getMessage());
        }
        try {
            performanceEvaluator = OperatorService.createOperator(SimplePerformanceEvaluator.class);
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 904, "performance evaluation operator", e.getMessage());
        }
        boolean[] mask = new boolean[exampleSet.getAttributes().size()];
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            mask[i] = true;
            if (i > 0) {
                mask[i - 1] = false;
            }
            ExampleSet singleAttributeSet = new AttributeSelectionExampleSet(exampleSet, mask);
            Model model = learner.doWork(singleAttributeSet);
            singleAttributeSet = model.apply(singleAttributeSet);
            PerformanceVector performance = performanceEvaluator.doWork(singleAttributeSet);
            double weight = performance.getCriterion(0).getAverage();
            weights.setWeight(attribute.getName(), weight);
            ++i;
        }
        return weights;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_LABEL: 
            case POLYNOMINAL_LABEL: 
            case BINOMINAL_ATTRIBUTES: 
            case POLYNOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: {
                return true;
            }
        }
        return false;
    }
}

