/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.dialog.AttributeWeightsDialog;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;

public class InteractiveAttributeWeighting
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private InputPort weightInput = (InputPort)this.getInputPorts().createPort("weight");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort weightOutput = (OutputPort)this.getOutputPorts().createPort("weight");

    public InteractiveAttributeWeighting(OperatorDescription description) {
        super(description);
        this.weightInput.addPrecondition(new SimplePrecondition(this.weightInput, new MetaData(AttributeWeights.class), false));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addPassThroughRule(this.weightInput, this.weightOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        AttributeWeights weights = (AttributeWeights)this.weightInput.getDataOrNull();
        ExampleSet exampleSet = null;
        if (weights == null) {
            this.log("No feature weights found in input. Trying to find an example set...");
            weights = new AttributeWeights();
            exampleSet = (ExampleSet)this.exampleSetInput.getDataOrNull();
            if (exampleSet != null) {
                for (Attribute attribute : exampleSet.getAttributes()) {
                    weights.setWeight(attribute.getName(), 1.0);
                }
                this.log("ExampleSet found! Initially all attributes will be used with weight 1.");
            } else {
                this.log("No examples found! Starting dialog without any weights.");
            }
        }
        AttributeWeightsDialog attributeWeightsDialog = new AttributeWeightsDialog(weights);
        attributeWeightsDialog.setVisible(true);
        if (attributeWeightsDialog.isOk()) {
            weights = attributeWeightsDialog.getAttributeWeights();
        }
        this.weightOutput.deliver(weights);
        this.exampleSetOutput.deliver(exampleSet);
    }
}

