/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.weighting.FeatureWeighting;
import com.rapidminer.operator.features.weighting.SimpleWeighting;

public class ForwardWeighting
extends FeatureWeighting {
    public ForwardWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public PopulationOperator getWeightingOperator(String parameter) {
        double[] weights = new double[]{0.25, 0.5, 0.75, 1.0};
        if (parameter != null && parameter.length() != 0) {
            try {
                String[] weightStrings = parameter.split(" ");
                weights = new double[weightStrings.length];
                for (int i = 0; i < weights.length; ++i) {
                    weights[i] = Double.parseDouble(weightStrings[i]);
                }
            }
            catch (Exception e) {
                this.logError("Could not create weights: " + e.getMessage() + "! Use standard weights.");
                weights = new double[]{0.25, 0.5, 0.75, 1.0};
            }
        }
        return new SimpleWeighting(0.0, weights);
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) {
        Population initPop = new Population();
        for (int i = 0; i < es.getAttributes().size(); ++i) {
            double[] weights = new double[es.getAttributes().size()];
            weights[i] = 1.0;
            initPop.add(new Individual(weights));
        }
        return initPop;
    }
}

