/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.KeepBest;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.RedundanceRemoval;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;

public abstract class FeatureWeighting
extends FeatureOperator {
    public static final String PARAMETER_KEEP_BEST = "keep_best";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_WEIGHTS = "weights";
    private List<PopulationOperator> preOps = new LinkedList<PopulationOperator>();
    private List<PopulationOperator> postOps = new LinkedList<PopulationOperator>();
    private int generationsWOImp = 0;

    public abstract PopulationOperator getWeightingOperator(String var1);

    public FeatureWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork() throws OperatorException {
        this.generationsWOImp = this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL);
        this.preOps = new LinkedList<PopulationOperator>();
        this.preOps.add(new KeepBest(this.getParameterAsInt(PARAMETER_KEEP_BEST)));
        this.preOps.add(this.getWeightingOperator(this.getParameterAsString(PARAMETER_WEIGHTS)));
        this.preOps.add(new RedundanceRemoval());
        this.postOps = new LinkedList<PopulationOperator>();
        super.doWork();
    }

    @Override
    public boolean solutionGoodEnough(Population population) {
        boolean stop = population.empty() || population.getGenerationsWithoutImproval() >= this.generationsWOImp;
        return stop;
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet eSet) {
        return this.preOps;
    }

    @Override
    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet eSet) {
        return this.postOps;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_KEEP_BEST, "Keep the best n individuals in each generation.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop after n generations without improvement of the performance.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_WEIGHTS, "Use these weights for the creation of individuals in each generation.", true));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

