/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.selection.AbstractGeneticAlgorithm;
import com.rapidminer.operator.features.selection.SelectionCrossover;
import com.rapidminer.operator.features.weighting.VarianceAdaption;
import com.rapidminer.operator.features.weighting.WeightingMutation;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.LinkedList;
import java.util.List;

public class EvolutionaryWeighting
extends AbstractGeneticAlgorithm {
    public static final String PARAMETER_MUTATION_VARIANCE = "mutation_variance";
    public static final String PARAMETER_1_5_RULE = "1_5_rule";
    public static final String PARAMETER_BOUNDED_MUTATION = "bounded_mutation";
    public static final String PARAMETER_P_CROSSOVER = "p_crossover";
    public static final String PARAMETER_CROSSOVER_TYPE = "crossover_type";
    public static final String PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS = "initialize_with_input_weights";
    public static final String PARAMETER_NOMINAL_MUTATION_RATE = "nominal_mutation_rate";
    public static final String PARAMETER_DEFAULT_NOMINAL_MUTATION_RATE = "use_default_mutation_rate";
    private WeightingMutation weighting = null;
    private boolean useBoundedMutation = false;
    private final InputPort attributeWeightsInput = (InputPort)this.getInputPorts().createPort("attribute weights in");

    public EvolutionaryWeighting(OperatorDescription description) {
        super(description);
        this.attributeWeightsInput.addPrecondition(new SimplePrecondition(this.attributeWeightsInput, new MetaData(AttributeWeights.class), false));
    }

    @Override
    public PopulationOperator getCrossoverPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        return new SelectionCrossover(this.getParameterAsInt(PARAMETER_CROSSOVER_TYPE), this.getParameterAsDouble(PARAMETER_P_CROSSOVER), this.getRandom(), 1, eSet.getAttributes().size(), -1);
    }

    @Override
    public PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        Attributes attributes = eSet.getAttributes();
        boolean[] isNominal = new boolean[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            isNominal[i] = attribute.isNominal();
            ++i;
        }
        double nominalMutationProb = 1.0 / (double)attributes.size();
        if (!this.getParameterAsBoolean(PARAMETER_DEFAULT_NOMINAL_MUTATION_RATE)) {
            nominalMutationProb = this.getParameterAsDouble(PARAMETER_NOMINAL_MUTATION_RATE);
        }
        this.weighting = new WeightingMutation(this.getParameterAsDouble(PARAMETER_MUTATION_VARIANCE), this.useBoundedMutation, isNominal, nominalMutationProb, this.getRandom());
        return this.weighting;
    }

    @Override
    protected List<PopulationOperator> getPostProcessingPopulationOperators(ExampleSet eSet) throws UndefinedParameterError {
        LinkedList<PopulationOperator> otherPostOps = new LinkedList<PopulationOperator>();
        if (this.getParameterAsBoolean(PARAMETER_1_5_RULE)) {
            otherPostOps.add(new VarianceAdaption(this.weighting, eSet.getAttributes().size()));
        }
        return otherPostOps;
    }

    @Override
    public void doWork() throws OperatorException {
        boolean useBoundedMutation = this.getParameterAsBoolean(PARAMETER_BOUNDED_MUTATION);
        if (!useBoundedMutation) {
            ExampleSet exampleSet = (ExampleSet)this.getExampleSetInput().getData();
            boolean containsNominalAttributes = false;
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (!attribute.isNominal()) continue;
                containsNominalAttributes = true;
                break;
            }
            if (containsNominalAttributes) {
                useBoundedMutation = true;
                this.logWarning("If ExampleSet contains nominal attributes, bounded mutation must be used: Switched to bounded mutation automatically.");
            }
        }
        super.doWork();
    }

    @Override
    public Population createInitialPopulation(ExampleSet exampleSet) throws OperatorException {
        int w;
        double[] weights;
        Population initPop = new Population();
        int numberOfIndividuals = this.getParameterAsInt("population_size");
        double[] initialWeights = null;
        if (this.getParameterAsBoolean(PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS)) {
            AttributeWeights inputWeights = null;
            inputWeights = (AttributeWeights)this.attributeWeightsInput.getData();
            initialWeights = new double[exampleSet.getAttributes().size()];
            int index = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double weight = inputWeights.getWeight(attribute.getName());
                if (Double.isNaN(weight)) {
                    weight = this.getRandom().nextDouble();
                }
                initialWeights[index++] = weight;
            }
            initPop.add(new Individual(initialWeights));
        }
        if (initialWeights != null) {
            while (initPop.getNumberOfIndividuals() < numberOfIndividuals / 2) {
                weights = new double[exampleSet.getAttributes().size()];
                for (w = 0; w < weights.length; ++w) {
                    weights[w] = Math.min(1.0, Math.max(0.0, initialWeights[w] + this.getRandom().nextGaussian() * 0.1));
                }
                initPop.add(new Individual(weights));
            }
        }
        while (initPop.getNumberOfIndividuals() < numberOfIndividuals) {
            weights = new double[exampleSet.getAttributes().size()];
            for (w = 0; w < weights.length; ++w) {
                weights[w] = this.getRandom().nextDouble();
            }
            initPop.add(new Individual(weights));
        }
        return initPop;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_MUTATION_VARIANCE, "The (initial) variance for each mutation.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean(PARAMETER_1_5_RULE, "If set to true, the 1/5 rule for variance adaption is used.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_BOUNDED_MUTATION, "If set to true, the weights are bounded between 0 and 1.", false));
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_P_CROSSOVER, "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.0);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_CROSSOVER_TYPE, "Type of the crossover.", SelectionCrossover.CROSSOVER_TYPES, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_DEFAULT_NOMINAL_MUTATION_RATE, "Use the default mutation rate for nominal attributes.", true));
        type = new ParameterTypeDouble(PARAMETER_NOMINAL_MUTATION_RATE, "The probability to switch nominal attributes between 0 and 1.", 0.0, 1.0);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_DEFAULT_NOMINAL_MUTATION_RATE, true, false));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS, "Indicates if this operator should look for attribute weights in the given input and use the input weights of all known attributes as starting point for the optimization.", false));
        return types;
    }
}

