/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.transformation.ComponentWeightsCreatable;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

public class ComponentWeights
extends AbstractWeighting {
    private InputPort modelInput = this.getInputPorts().createPort("model", Model.class);
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    public static final String PARAMETER_COMPONENT_NUMBER = "component_number";

    public ComponentWeights(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.modelInput, this.modelOutput);
    }

    public AttributeWeights doWork(Model model, ExampleSet exampleSet) throws OperatorException {
        this.modelInput.receive(model);
        this.getExampleSetInputPort().receive(exampleSet);
        this.doWork();
        return (AttributeWeights)this.getWeightsOutputPort().getData();
    }

    @Override
    protected AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        Model model = (Model)this.modelInput.getData();
        if (!(model instanceof ComponentWeightsCreatable)) {
            throw new OperatorException(this.getName() + ": needs an input model wich implements the ComponentWeightsCreatable interface:" + model.getClass().getName());
        }
        int component = this.getParameterAsInt(PARAMETER_COMPONENT_NUMBER);
        AttributeWeights weights = ((ComponentWeightsCreatable)((Object)model)).getWeightsOfComponent(component);
        if (this.getParameterAsBoolean("normalize_weights")) {
            weights.normalize();
        }
        this.modelOutput.deliver(model);
        return weights;
    }

    @Override
    protected boolean isExampleSetMandatory() {
        return false;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        list.addAll(super.getParameterTypes());
        list.add(new ParameterTypeInt(PARAMETER_COMPONENT_NUMBER, "Create the weights of this component.", 1, Integer.MAX_VALUE, 1));
        return list;
    }
}

