/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import java.util.LinkedList;

public class AttributeWeights2ExampleSet
extends Operator {
    private InputPort weightInput = this.getInputPorts().createPort("attribute weights", AttributeWeights.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public AttributeWeights2ExampleSet(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new GenerateNewExampleSetMDRule(this.exampleSetOutput){

            @Override
            public MetaData modifyMetaData(ExampleSetMetaData emd) {
                AttributeMetaData attributeAMD = new AttributeMetaData("Attribute", 1);
                AttributeMetaData weightAMD = new AttributeMetaData("Weight", 4);
                emd.addAttribute(attributeAMD);
                emd.addAttribute(weightAMD);
                emd.attributesAreKnown();
                emd.numberOfExamplesIsUnkown();
                return emd;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        AttributeWeights weights = (AttributeWeights)this.weightInput.getData();
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        Attribute nameAttribute = AttributeFactory.createAttribute("Attribute", 1);
        Attribute weightAttribute = AttributeFactory.createAttribute("Weight", 4);
        attributes.add(nameAttribute);
        attributes.add(weightAttribute);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (String name : weights.getAttributeNames()) {
            double[] data = new double[]{nameAttribute.getMapping().mapString(name), weights.getWeight(name)};
            table.addDataRow(new DoubleArrayDataRow(data));
        }
        this.exampleSetOutput.deliver(table.createExampleSet());
    }
}

