/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.CapabilityCheck;
import com.rapidminer.operator.learner.CapabilityProvider;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.CapabilityPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.Tools;
import java.util.List;

public abstract class AbstractWeighting
extends Operator
implements CapabilityProvider {
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private static final String[] SORT_DIRECTIONS = new String[]{"ascending", "descending"};
    public static final int SORT_ASCENDING = 0;
    public static final int SORT_DESCENDING = 1;
    public static final String PARAMETER_NORMALIZE_WEIGHTS = "normalize_weights";
    public static final String PARAMETER_SORT_WEIGHTS = "sort_weights";
    public static final String PARAMETER_SORT_DIRECTION = "sort_direction";

    public AbstractWeighting(OperatorDescription description) {
        super(description);
        if (this.isExampleSetMandatory()) {
            this.exampleSetInput.addPrecondition(new CapabilityPrecondition(this, this.exampleSetInput));
        }
        this.getTransformer().addRule(new GenerateNewMDRule(this.weightsOutput, AttributeWeights.class));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                boolean normalizedWeights = AbstractWeighting.this.getParameterAsBoolean(AbstractWeighting.PARAMETER_NORMALIZE_WEIGHTS);
                for (AttributeMetaData amd : metaData.getAllAttributes()) {
                    if (amd.isSpecial() || !amd.isNumerical()) continue;
                    if (normalizedWeights) {
                        amd.setValueSetRelation(SetRelation.SUBSET);
                        continue;
                    }
                    amd.setValueSetRelation(SetRelation.UNKNOWN);
                }
                return super.modifyExampleSet(metaData);
            }
        });
    }

    protected abstract AttributeWeights calculateWeights(ExampleSet var1) throws OperatorException;

    public AttributeWeights doWork(ExampleSet exampleSet) throws OperatorException {
        this.exampleSetInput.receive(exampleSet);
        CapabilityCheck check = new CapabilityCheck(this, Tools.booleanValue(System.getProperty("rapidminer.general.capabilities.warn"), true) || this.onlyWarnForNonSufficientCapabilities());
        check.checkLearnerCapabilities(this, exampleSet);
        this.doWork();
        return (AttributeWeights)this.weightsOutput.getData();
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        AttributeWeights weights = this.calculateWeights(exampleSet);
        if (this.getParameterAsBoolean(PARAMETER_NORMALIZE_WEIGHTS)) {
            weights.normalize();
        }
        if (this.getParameterAsBoolean(PARAMETER_NORMALIZE_WEIGHTS)) {
            weights.sort(this.getParameterAsInt(PARAMETER_SORT_DIRECTION) == 0 ? -1 : 1, 0);
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.weightsOutput.deliver(weights);
    }

    public InputPort getExampleSetInputPort() {
        return this.exampleSetInput;
    }

    public OutputPort getWeightsOutputPort() {
        return this.weightsOutput;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        list.add(new ParameterTypeBoolean(PARAMETER_NORMALIZE_WEIGHTS, "Activates the normalization of all weights.", true, false));
        list.add(new ParameterTypeBoolean(PARAMETER_SORT_WEIGHTS, "If activated the weights will be returned sorted.", true, false));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_SORT_DIRECTION, "Defines the sorting direction.", SORT_DIRECTIONS, 0);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_SORT_WEIGHTS, true, true));
        list.add(type);
        return list;
    }

    protected boolean isExampleSetMandatory() {
        return true;
    }

    protected boolean onlyWarnForNonSufficientCapabilities() {
        return false;
    }
}

