/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.transformation.SOMDimensionalityReduction;
import com.rapidminer.tools.math.som.KohonenNet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class SOMDimensionalityReductionModel
extends AbstractModel {
    private static final long serialVersionUID = 7249399167412746295L;
    private KohonenNet net;
    private int dimensions;

    protected SOMDimensionalityReductionModel(ExampleSet exampleSet, KohonenNet net, int dimensions) {
        super(exampleSet);
        this.net = net;
        this.dimensions = dimensions;
    }

    @Override
    public String getName() {
        return "SOM Dimensionality Reduction Model";
    }

    @Override
    public String toString() {
        return "Transforms the input data into a new data set with " + this.dimensions + " dimensions.";
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (int i = 0; i < this.dimensions; ++i) {
            attributes.add(AttributeFactory.createAttribute("SOM_" + i, 2));
        }
        Iterator<AttributeRole> s = exampleSet.getAttributes().specialAttributes();
        HashMap<Attribute, String> newSpecialAttributes = new HashMap<Attribute, String>();
        while (s.hasNext()) {
            AttributeRole role = s.next();
            Attribute specialAttribute = role.getAttribute();
            Attribute newAttribute = (Attribute)specialAttribute.clone();
            attributes.add(newAttribute);
            newSpecialAttributes.put(newAttribute, role.getSpecialName());
        }
        MemoryExampleTable newDataTable = new MemoryExampleTable(attributes);
        for (Example currentExample : exampleSet) {
            int i;
            int[] coords = this.net.apply(SOMDimensionalityReduction.getDoubleArrayFromExample(currentExample));
            double[] exampleData = new double[attributes.size()];
            for (i = 0; i < this.dimensions; ++i) {
                exampleData[i] = coords[i];
            }
            s = exampleSet.getAttributes().specialAttributes();
            i = this.dimensions;
            while (s.hasNext()) {
                exampleData[i++] = currentExample.getValue(s.next().getAttribute());
            }
            DoubleArrayDataRow newRow = new DoubleArrayDataRow(exampleData);
            newDataTable.addDataRow(newRow);
        }
        return newDataTable.createExampleSet(newSpecialAttributes);
    }
}

