/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.gui.renderer.models.EigenvectorModelEigenvalueRenderer;
import com.rapidminer.gui.renderer.models.EigenvectorModelEigenvectorRenderer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.AbstractEigenvectorModel;
import com.rapidminer.operator.features.transformation.ComponentWeightsCreatable;
import com.rapidminer.operator.features.transformation.Eigenvector;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PCAModel
extends AbstractEigenvectorModel
implements ComponentWeightsCreatable {
    private static final long serialVersionUID = 5424591594470376525L;
    private List<Eigenvector> eigenVectors;
    private double[] means;
    private String[] attributeNames;
    private boolean manualNumber;
    private int numberOfComponents = -1;
    private double varianceThreshold;
    private double[] variances;
    private double[] cumulativeVariance;
    private boolean keepAttributes = false;

    public PCAModel(ExampleSet eSet, double[] eigenvalues, double[][] eigenvectors) {
        super(eSet);
        this.attributeNames = new String[eSet.getAttributes().size()];
        this.means = new double[eSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : eSet.getAttributes()) {
            this.attributeNames[counter] = attribute.getName();
            this.means[counter] = eSet.getStatistics(attribute, "average");
            ++counter;
        }
        this.eigenVectors = new ArrayList<Eigenvector>(eigenvalues.length);
        for (int i = 0; i < eigenvalues.length; ++i) {
            double[] currentEigenVector = new double[eSet.getAttributes().size()];
            for (int j = 0; j < currentEigenVector.length; ++j) {
                currentEigenVector[j] = eigenvectors[j][i];
            }
            this.eigenVectors.add(new Eigenvector(currentEigenVector, eigenvalues[i]));
        }
        Collections.sort(this.eigenVectors);
        this.calculateCumulativeVariance();
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public double[] getMeans() {
        return this.means;
    }

    public double getMean(int index) {
        return this.means[index];
    }

    public double getVariance(int index) {
        return this.variances[index];
    }

    public double getCumulativeVariance(int index) {
        return this.cumulativeVariance[index];
    }

    public double getEigenvalue(int index) {
        return this.eigenVectors.get(index).getEigenvalue();
    }

    public double[] getEigenvector(int index) {
        return this.eigenVectors.get(index).getEigenvector();
    }

    public double getVarianceThreshold() {
        return this.varianceThreshold;
    }

    public int getMaximumNumberOfComponents() {
        return this.attributeNames.length;
    }

    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    public void setVarianceThreshold(double threshold) {
        this.manualNumber = false;
        this.varianceThreshold = threshold;
        this.numberOfComponents = -1;
    }

    public void setNumberOfComponents(int numberOfComponents) {
        this.varianceThreshold = 0.95;
        this.manualNumber = true;
        this.numberOfComponents = numberOfComponents;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        if (this.attributeNames.length != exampleSet.getAttributes().size()) {
            throw new UserError(null, 133, this.numberOfComponents, exampleSet.getAttributes().size());
        }
        double[][] data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        Iterator reader = exampleSet.iterator();
        for (int sample = 0; sample < exampleSet.size(); ++sample) {
            Example example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : example.getAttributes()) {
                data[sample][d] = example.getValue(attribute) - this.means[d];
                ++d;
            }
        }
        Matrix dataMatrix = new Matrix(data);
        double[][] values = new double[this.eigenVectors.size()][this.attributeNames.length];
        int counter = 0;
        for (Eigenvector ev : this.eigenVectors) {
            values[counter++] = ev.getEigenvector();
        }
        Matrix eigenvectorMatrix = new Matrix(values).transpose();
        Matrix finaldataMatrix = dataMatrix.times(eigenvectorMatrix);
        int components = -1;
        if (this.manualNumber) {
            components = this.numberOfComponents;
        } else if (this.varianceThreshold == 0.0) {
            components = -1;
        } else {
            components = 0;
            while (this.cumulativeVariance[components] < this.varianceThreshold) {
                ++components;
            }
            if (++components == this.eigenVectors.size()) {
                --components;
            }
        }
        if (components == -1) {
            components = exampleSet.getAttributes().size();
        }
        this.log("Number of components: " + components);
        finaldataMatrix = new Matrix(finaldataMatrix.getArray(), exampleSet.size(), components);
        double[][] finaldata = finaldataMatrix.getArray();
        if (!this.keepAttributes) {
            exampleSet.getAttributes().clearRegular();
        }
        this.log("Adding new the derived features...");
        Attribute[] pcatts = new Attribute[components];
        for (int i = 0; i < components; ++i) {
            pcatts[i] = AttributeFactory.createAttribute("pc_" + (i + 1), 4);
            exampleSet.getExampleTable().addAttribute(pcatts[i]);
            exampleSet.getAttributes().addRegular(pcatts[i]);
        }
        reader = exampleSet.iterator();
        for (int sample = 0; sample < exampleSet.size(); ++sample) {
            Example example = (Example)reader.next();
            for (int d = 0; d < components; ++d) {
                example.setValue(pcatts[d], finaldata[sample][d]);
            }
        }
        return exampleSet;
    }

    private void calculateCumulativeVariance() {
        double sumvariance = 0.0;
        for (Eigenvector ev : this.eigenVectors) {
            sumvariance += ev.getEigenvalue();
        }
        this.variances = new double[this.eigenVectors.size()];
        this.cumulativeVariance = new double[this.variances.length];
        double cumulative = 0.0;
        int counter = 0;
        for (Eigenvector ev : this.eigenVectors) {
            double proportion;
            this.variances[counter] = proportion = ev.getEigenvalue() / sumvariance;
            this.cumulativeVariance[counter] = cumulative += proportion;
            ++counter;
        }
    }

    @Override
    public void setParameter(String name, Object object) throws OperatorException {
        if (name.equals("variance_threshold")) {
            String value = (String)object;
            try {
                this.setVarianceThreshold(Double.parseDouble(value));
            }
            catch (NumberFormatException error) {
                super.setParameter(name, value);
            }
        } else if (name.equals("number_of_components")) {
            String value = (String)object;
            try {
                this.setNumberOfComponents(Integer.parseInt(value));
            }
            catch (NumberFormatException error) {
                super.setParameter(name, value);
            }
        } else if (name.equals("keep_attributes")) {
            String value = (String)object;
            this.keepAttributes = false;
            if (value.equals("true")) {
                this.keepAttributes = true;
            }
        } else {
            super.setParameter(name, object);
        }
    }

    @Override
    public AttributeWeights getWeightsOfComponent(int component) throws OperatorException {
        if (component < 1) {
            component = 1;
        }
        if (component > this.attributeNames.length) {
            this.logWarning("Creating weights of component " + this.attributeNames.length + "!");
            component = this.attributeNames.length;
        }
        AttributeWeights weights = new AttributeWeights();
        for (int i = 0; i < this.attributeNames.length; ++i) {
            weights.setWeight(this.attributeNames[i], this.eigenVectors.get(component - 1).getEigenvector()[i]);
        }
        return weights;
    }

    @Override
    public String toResultString() {
        StringBuilder result = new StringBuilder(Tools.getLineSeparator() + "Principal Components:" + Tools.getLineSeparator());
        if (this.manualNumber) {
            result.append("Number of Components: " + this.numberOfComponents + Tools.getLineSeparator());
        } else {
            result.append("Variance Threshold: " + this.varianceThreshold + Tools.getLineSeparator());
        }
        for (int i = 0; i < this.eigenVectors.size(); ++i) {
            result.append("PC " + (i + 1) + ": ");
            for (int j = 0; j < this.attributeNames.length; ++j) {
                double value = this.eigenVectors.get(i).getEigenvector()[j];
                if (value > 0.0) {
                    result.append(" + ");
                } else {
                    result.append(" - ");
                }
                result.append(Tools.formatNumber(Math.abs(value)) + " * " + this.attributeNames[j]);
            }
            result.append(Tools.getLineSeparator());
        }
        return result.toString();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(Tools.getLineSeparator() + "Principal Components:" + Tools.getLineSeparator());
        if (this.manualNumber) {
            result.append("Number of Components: " + this.numberOfComponents + Tools.getLineSeparator());
        } else {
            result.append("Variance Threshold: " + this.varianceThreshold + Tools.getLineSeparator());
        }
        return result.toString();
    }

    @Override
    public double[] getCumulativeVariance() {
        double[] cumulativeVariance = new double[this.attributeNames.length];
        double varianceSum = 0.0;
        int i = 0;
        for (Eigenvector wv : this.eigenVectors) {
            cumulativeVariance[i++] = varianceSum += wv.getEigenvalue();
        }
        return cumulativeVariance;
    }

    @Override
    public EigenvectorModelEigenvalueRenderer.EigenvalueTableModel getEigenvalueTableModel() {
        double varianceSum = 0.0;
        for (Eigenvector wv : this.eigenVectors) {
            varianceSum += wv.getEigenvalue();
        }
        return new EigenvectorModelEigenvalueRenderer.EigenvalueTableModel(this.eigenVectors, this.cumulativeVariance, varianceSum);
    }

    @Override
    public EigenvectorModelEigenvectorRenderer.EigenvectorTableModel getEigenvectorTableModel() {
        return new EigenvectorModelEigenvectorRenderer.EigenvectorTableModel(this.eigenVectors, this.attributeNames, this.attributeNames.length);
    }
}

