/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.transformation.PCAModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.GenerateModelTransformationRule;
import com.rapidminer.operator.ports.metadata.MDReal;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.math.matrix.CovarianceMatrix;
import java.util.List;

public class PCA
extends Operator {
    public static final String PARAMETER_VARIANCE_THRESHOLD = "variance_threshold";
    public static final String PARAMETER_NUMBER_OF_COMPONENTS = "number_of_components";
    public static final String PARAMETER_REDUCTION_TYPE = "dimensionality_reduction";
    public static final String[] REDUCTION_METHODS = new String[]{"none", "keep variance", "fixed number"};
    public static final int REDUCTION_NONE = 0;
    public static final int REDUCTION_VARIANCE = 1;
    public static final int REDUCTION_FIXED = 2;
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private OutputPort originalOutput = (OutputPort)this.getOutputPorts().createPort("original");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("preprocessing model");

    public PCA(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 2, new String[0]));
        this.getTransformer().addRule(new GenerateModelTransformationRule(this.exampleSetInput, this.modelOutput, PCAModel.class));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                int numberOfAttributes;
                int resultNumber = numberOfAttributes = metaData.getNumberOfRegularAttributes();
                if (PCA.this.getParameterAsInt(PCA.PARAMETER_REDUCTION_TYPE) == 2) {
                    resultNumber = PCA.this.getParameterAsInt(PCA.PARAMETER_NUMBER_OF_COMPONENTS);
                    metaData.attributesAreKnown();
                } else if (PCA.this.getParameterAsInt(PCA.PARAMETER_REDUCTION_TYPE) == 1) {
                    resultNumber = numberOfAttributes;
                    metaData.attributesAreSubset();
                }
                metaData.clearRegular();
                for (int i = 1; i <= resultNumber; ++i) {
                    AttributeMetaData pcAMD = new AttributeMetaData("pc_" + i, 4);
                    pcAMD.setMean(new MDReal(0.0));
                    metaData.addAttribute(pcAMD);
                }
                return metaData;
            }
        });
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.originalOutput, false));
    }

    public Model doWork(ExampleSet exampleSet) throws OperatorException {
        this.exampleSetInput.receive(exampleSet);
        this.doWork();
        return (Model)this.modelOutput.getData();
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Tools.onlyNonMissingValues(exampleSet, "PCA");
        Tools.onlyNumericalAttributes(exampleSet, "PCA");
        this.log("Creating the covariance matrix...");
        Matrix covarianceMatrix = CovarianceMatrix.getCovarianceMatrix(exampleSet);
        this.log("Performing the eigenvalue decomposition...");
        EigenvalueDecomposition eigenvalueDecomposition = covarianceMatrix.eig();
        double[] eigenvalues = eigenvalueDecomposition.getRealEigenvalues();
        Matrix eigenvectorMatrix = eigenvalueDecomposition.getV();
        double[][] eigenvectors = eigenvectorMatrix.getArray();
        PCAModel model = new PCAModel(exampleSet, eigenvalues, eigenvectors);
        int reductionType = this.getParameterAsInt(PARAMETER_REDUCTION_TYPE);
        switch (reductionType) {
            case 0: {
                model.setNumberOfComponents(exampleSet.getAttributes().size());
                break;
            }
            case 1: {
                model.setVarianceThreshold(this.getParameterAsDouble(PARAMETER_VARIANCE_THRESHOLD));
                break;
            }
            case 2: {
                model.setNumberOfComponents(this.getParameterAsInt(PARAMETER_NUMBER_OF_COMPONENTS));
            }
        }
        this.modelOutput.deliver(model);
        this.originalOutput.deliver(exampleSet);
        if (this.exampleSetOutput.isConnected()) {
            this.exampleSetOutput.deliver(model.apply((ExampleSet)exampleSet.clone()));
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_REDUCTION_TYPE, "Indicates which type of dimensionality reduction should be applied", REDUCTION_METHODS, 1);
        type.setExpert(false);
        list.add(type);
        type = new ParameterTypeDouble(PARAMETER_VARIANCE_THRESHOLD, "Keep the all components with a cumulative variance smaller than the given threshold.", 0.0, 1.0, 0.95);
        type.setExpert(false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_REDUCTION_TYPE, REDUCTION_METHODS, true, 1));
        list.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_COMPONENTS, "Keep this number of components.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_REDUCTION_TYPE, REDUCTION_METHODS, true, 2));
        list.add(type);
        return list;
    }
}

