/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.math.kernels.Kernel;
import java.util.ArrayList;

public class KernelPCAModel
extends AbstractModel {
    private static final long serialVersionUID = -6699248775014738833L;
    private Matrix eigenVectors;
    private ArrayList<double[]> exampleValues;
    private Kernel kernel;
    private ArrayList<String> attributeNames;
    private double[] means;

    protected KernelPCAModel(ExampleSet exampleSet) {
        super(exampleSet);
    }

    public KernelPCAModel(ExampleSet exampleSet, double[] means, Matrix eigenVectors, ArrayList<double[]> exampleValues, Kernel kernel) {
        super(exampleSet);
        this.eigenVectors = eigenVectors;
        this.exampleValues = exampleValues;
        this.kernel = kernel;
        this.means = means;
        this.attributeNames = new ArrayList();
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.attributeNames.add(attribute.getName());
        }
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attributes attributes = (Attributes)exampleSet.getAttributes().clone();
        this.checkNames(attributes);
        this.log("Adding new the derived features...");
        Attribute[] pcatts = new Attribute[this.exampleValues.size()];
        for (int i = 0; i < this.exampleValues.size(); ++i) {
            pcatts[i] = AttributeFactory.createAttribute("kpc_" + (i + 1), 4);
            exampleSet.getExampleTable().addAttribute(pcatts[i]);
            exampleSet.getAttributes().addRegular(pcatts[i]);
        }
        this.log("Calculating new features");
        Matrix distanceValues = new Matrix(1, this.exampleValues.size());
        for (Example example : exampleSet) {
            int i = 0;
            for (double[] trainValue : this.exampleValues) {
                distanceValues.set(0, i++, this.kernel.calculateDistance(trainValue, this.getAttributeValues(example, attributes)));
            }
            Matrix resultValues = this.eigenVectors.times(distanceValues.transpose());
            for (int j = 0; j < this.exampleValues.size(); ++j) {
                example.setValue(pcatts[j], resultValues.get(j, 0));
            }
        }
        exampleSet.getAttributes().clearRegular();
        for (Attribute attribute : pcatts) {
            exampleSet.getAttributes().addRegular(attribute);
        }
        return exampleSet;
    }

    private void checkNames(Attributes attributes) throws UserError {
        int i = 0;
        for (Attribute attribute : attributes) {
            if (attribute.getName().equals(this.attributeNames.get(i++))) continue;
            throw new UserError(null, 141);
        }
    }

    private double[] getAttributeValues(Example example, Attributes attributes) {
        double[] values = new double[attributes.size()];
        int x = 0;
        for (Attribute attribute : attributes) {
            values[x] = example.getValue(attribute) - this.means[x];
            ++x;
        }
        return values;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Model uses " + this.exampleValues.size() + " Examples for calculating transformation\n");
        buffer.append("Kernel used for distance calculation:\n " + this.kernel.toString());
        return buffer.toString();
    }
}

