/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.transformation.KernelPCAModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.kernels.Kernel;
import java.util.ArrayList;
import java.util.List;

public class KernelPCA
extends Operator {
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private OutputPort originalOutput = (OutputPort)this.getOutputPorts().createPort("original");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("preprocessing model");

    public KernelPCA(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 2, new String[0]));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                switch (metaData.getNumberOfExamples().getRelation()) {
                    case EQUAL: {
                        metaData.attributesAreKnown();
                        break;
                    }
                    case AT_LEAST: {
                        metaData.attributesAreSubset();
                        break;
                    }
                    case AT_MOST: 
                    case UNKNOWN: {
                        metaData.attributesAreSuperset();
                    }
                }
                if (metaData.getNumberOfExamples().getNumber() != null) {
                    int numberOfExamples = (Integer)metaData.getNumberOfExamples().getNumber();
                    metaData.clearRegular();
                    for (int i = 1; i <= numberOfExamples; ++i) {
                        metaData.addAttribute(new AttributeMetaData("kpc_" + i, 4));
                    }
                }
                return super.modifyExampleSet(metaData);
            }
        });
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.originalOutput, false));
        this.getTransformer().addGenerationRule(this.modelOutput, Model.class);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Tools.onlyNumericalAttributes(exampleSet, "KernelPCA");
        Tools.onlyNonMissingValues(exampleSet, "KernelPCA");
        Attributes attributes = exampleSet.getAttributes();
        int numberOfExamples = exampleSet.size();
        exampleSet.recalculateAllAttributeStatistics();
        double[] means = new double[exampleSet.getAttributes().size()];
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            means[i] = exampleSet.getStatistics(attribute, "average");
            ++i;
        }
        Kernel kernel = Kernel.createKernel(this);
        ArrayList<double[]> exampleValues = new ArrayList<double[]>(numberOfExamples);
        i = 0;
        for (Example columnExample : exampleSet) {
            double[] columnValues = this.getAttributeValues(columnExample, attributes, means);
            exampleValues.add(columnValues);
            ++i;
        }
        Matrix kernelMatrix = new Matrix(numberOfExamples, numberOfExamples);
        for (i = 0; i < numberOfExamples; ++i) {
            for (int j = 0; j < numberOfExamples; ++j) {
                kernelMatrix.set(i, j, kernel.calculateDistance((double[])exampleValues.get(i), exampleValues.get(j)));
            }
        }
        EigenvalueDecomposition eig = kernelMatrix.eig();
        KernelPCAModel model = new KernelPCAModel(exampleSet, means, eig.getV(), exampleValues, kernel);
        if (this.exampleSetOutput.isConnected()) {
            this.exampleSetOutput.deliver(model.apply((ExampleSet)exampleSet.clone()));
        }
        this.originalOutput.deliver(exampleSet);
        this.modelOutput.deliver(model);
    }

    private double[] getAttributeValues(Example example, Attributes attributes, double[] means) {
        double[] values = new double[attributes.size()];
        int x = 0;
        for (Attribute attribute : attributes) {
            values[x] = example.getValue(attribute) - means[x];
            ++x;
        }
        return values;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(Kernel.getParameters(this));
        return types;
    }
}

