/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.gui.renderer.models.EigenvectorModelEigenvalueRenderer;
import com.rapidminer.gui.renderer.models.EigenvectorModelEigenvectorRenderer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.AbstractEigenvectorModel;
import com.rapidminer.operator.features.transformation.ComponentWeightsCreatable;
import com.rapidminer.operator.features.transformation.WeightVector;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.VectorMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class GHAModel
extends AbstractEigenvectorModel
implements ComponentWeightsCreatable {
    private static final long serialVersionUID = -5204076842779376622L;
    private int numberOfAttributes;
    private int numberOfComponents;
    private double[] means;
    private String[] attributeNames;
    private List<WeightVector> weightVectors;
    private boolean keepAttributes = false;

    public GHAModel(ExampleSet eSet, double[] eigenvalues, double[][] weights, double[] mean) {
        super(eSet);
        this.numberOfAttributes = weights[0].length;
        this.numberOfComponents = weights.length;
        this.means = mean;
        this.attributeNames = new String[this.numberOfAttributes];
        int i = 0;
        for (Attribute attribute : eSet.getAttributes()) {
            this.attributeNames[i++] = attribute.getName();
        }
        this.weightVectors = new ArrayList<WeightVector>(eigenvalues.length);
        for (i = 0; i < eigenvalues.length; ++i) {
            double[] currentVector = new double[eSet.getAttributes().size()];
            for (int j = 0; j < currentVector.length; ++j) {
                currentVector[j] = weights[i][j];
            }
            this.weightVectors.add(new WeightVector(currentVector, eigenvalues[i]));
        }
        Collections.sort(this.weightVectors);
    }

    public double[] getMean() {
        return this.means;
    }

    public double[] getWeights(int index) {
        return this.weightVectors.get(index).getWeights();
    }

    public double getEigenvalue(int index) {
        return this.weightVectors.get(index).getEigenvalue();
    }

    public double getNumberOfComponents() {
        return this.numberOfComponents;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Example example;
        exampleSet.recalculateAllAttributeStatistics();
        if (this.numberOfAttributes != exampleSet.getAttributes().size()) {
            throw new UserError(null, 133, this.numberOfAttributes, exampleSet.getAttributes().size());
        }
        double[][] data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        boolean haslabel = exampleSet.getAttributes().getLabel() != null;
        boolean haspredlabel = exampleSet.getAttributes().getPredictedLabel() != null;
        double[] labelvalues = new double[]{};
        double[] predvalues = new double[]{};
        if (haslabel) {
            labelvalues = new double[exampleSet.size()];
        }
        if (haspredlabel) {
            predvalues = new double[exampleSet.size()];
        }
        Iterator reader = exampleSet.iterator();
        for (int sample = 0; sample < exampleSet.size(); ++sample) {
            example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                data[sample][d] = example.getValue(attribute) - this.means[d];
                if (haslabel) {
                    labelvalues[sample] = example.getValue(example.getAttributes().getLabel());
                }
                if (haspredlabel) {
                    predvalues[sample] = example.getValue(example.getAttributes().getPredictedLabel());
                }
                ++d;
            }
        }
        Matrix dataMatrix = new Matrix(data);
        double[][] values = new double[this.weightVectors.size()][this.attributeNames.length];
        int counter = 0;
        for (WeightVector wv : this.weightVectors) {
            values[counter++] = wv.getWeights();
        }
        Matrix W = new Matrix(values);
        Matrix finaldataMatrix = dataMatrix.times(W.transpose());
        double[][] finaldata = finaldataMatrix.getArray();
        if (!this.keepAttributes) {
            exampleSet.getAttributes().clearRegular();
        }
        Attribute[] principalComponentAttributes = new Attribute[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            principalComponentAttributes[i] = AttributeFactory.createAttribute("pc_" + (i + 1), 4);
            exampleSet.getExampleTable().addAttribute(principalComponentAttributes[i]);
            exampleSet.getAttributes().addRegular(principalComponentAttributes[i]);
        }
        reader = exampleSet.iterator();
        for (int sample = 0; sample < exampleSet.size(); ++sample) {
            example = (Example)reader.next();
            for (int d = 0; d < this.numberOfComponents; ++d) {
                example.setValue(principalComponentAttributes[d], finaldata[sample][d]);
            }
        }
        return exampleSet;
    }

    @Override
    public void setParameter(String name, Object object) throws OperatorException {
        if (name.equals("number_of_components")) {
            String value = (String)object;
            try {
                this.numberOfComponents = Math.min(this.numberOfComponents, Integer.parseInt(value));
            }
            catch (NumberFormatException error) {
                super.setParameter(name, value);
            }
        } else if (name.equals("keep_attributes")) {
            String value = (String)object;
            this.keepAttributes = false;
            if (value.equals("true")) {
                this.keepAttributes = true;
            }
        } else {
            super.setParameter(name, object);
        }
    }

    @Override
    public AttributeWeights getWeightsOfComponent(int component) throws OperatorException {
        if (component < 1) {
            component = 1;
        }
        if (component > this.attributeNames.length) {
            this.logWarning("Creating weights of component " + this.attributeNames.length + "!");
            component = this.attributeNames.length;
        }
        AttributeWeights weights = new AttributeWeights();
        for (int i = 0; i < this.attributeNames.length; ++i) {
            weights.setWeight(this.attributeNames[i], this.weightVectors.get(component - 1).getWeights()[i]);
        }
        return weights;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(Tools.getLineSeparator() + "GHA Components:" + Tools.getLineSeparator());
        for (int i = 0; i < this.weightVectors.size(); ++i) {
            result.append("PC " + (i + 1) + ": ");
            for (int j = 0; j < this.attributeNames.length; ++j) {
                double value = this.weightVectors.get(i).getWeights()[j];
                if (value > 0.0) {
                    result.append(" + ");
                } else {
                    result.append(" - ");
                }
                result.append(Tools.formatNumber(Math.abs(value)) + " * " + this.attributeNames[j]);
            }
            result.append(Tools.getLineSeparator());
        }
        return result.toString();
    }

    @Override
    public EigenvectorModelEigenvectorRenderer.EigenvectorTableModel getEigenvectorTableModel() {
        return new EigenvectorModelEigenvectorRenderer.EigenvectorTableModel(this.weightVectors, this.attributeNames, this.numberOfComponents);
    }

    @Override
    public EigenvectorModelEigenvalueRenderer.EigenvalueTableModel getEigenvalueTableModel() {
        double[] cumulativeVariance = new double[this.numberOfComponents];
        double varianceSum = 0.0;
        int i = 0;
        for (WeightVector wv : this.weightVectors) {
            cumulativeVariance[i++] = varianceSum += wv.getEigenvalue();
        }
        return new EigenvectorModelEigenvalueRenderer.EigenvalueTableModel(this.weightVectors, VectorMath.vectorDivision(cumulativeVariance, varianceSum), varianceSum);
    }

    @Override
    public double[] getCumulativeVariance() {
        double[] cumulativeVariance = new double[this.numberOfComponents];
        double varianceSum = 0.0;
        int i = 0;
        for (WeightVector wv : this.weightVectors) {
            cumulativeVariance[i++] = varianceSum += wv.getEigenvalue();
        }
        return VectorMath.vectorDivision(cumulativeVariance, varianceSum);
    }
}

