/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.GHAModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.GenerateModelTransformationRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.matrix.CovarianceMatrix;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class GHA
extends Operator {
    public static final String PARAMETER_NUMBER_OF_COMPONENTS = "number_of_components";
    public static final String PARAMETER_NUMBER_OF_ITERATIONS = "number_of_iterations";
    public static final String PARAMETER_LEARNING_RATE = "learning_rate";
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private OutputPort originalOutput = (OutputPort)this.getOutputPorts().createPort("original");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("preprocessing model");

    public GHA(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 2, new String[0]));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.SUBSET){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                int numberOfAttributes = metaData.getNumberOfRegularAttributes();
                metaData.clearRegular();
                try {
                    int numberOfGeneratedAttributes = GHA.this.getParameterAsInt(GHA.PARAMETER_NUMBER_OF_COMPONENTS);
                    numberOfGeneratedAttributes = numberOfGeneratedAttributes == -1 ? numberOfAttributes : numberOfGeneratedAttributes;
                    for (int i = 1; i <= numberOfGeneratedAttributes; ++i) {
                        AttributeMetaData generatedAttribute = new AttributeMetaData("pc_" + i, 2);
                        metaData.addAttribute(generatedAttribute);
                    }
                    metaData.attributesAreKnown();
                    return metaData;
                }
                catch (UndefinedParameterError e) {
                    return metaData;
                }
            }
        });
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.originalOutput);
        this.getTransformer().addRule(new GenerateModelTransformationRule(this.exampleSetInput, this.modelOutput, GHAModel.class));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        RandomGenerator random = RandomGenerator.getRandomGenerator(this);
        exampleSet.recalculateAllAttributeStatistics();
        double[] means = new double[exampleSet.getAttributes().size()];
        int a = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) {
                throw new UserError((Operator)this, 104, "GHA", attribute.getName());
            }
            means[a] = exampleSet.getStatistics(attribute, "average");
            ++a;
        }
        this.log("Initialising the weight matrix...");
        double[][] data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        Iterator reader = exampleSet.iterator();
        for (int sample = 0; sample < exampleSet.size(); ++sample) {
            Example example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                data[sample][d] = example.getValue(attribute) - means[d];
                ++d;
            }
            this.checkForStop();
        }
        double learningRate = this.getParameterAsDouble(PARAMETER_LEARNING_RATE);
        int numberOfComponents = this.getParameterAsInt(PARAMETER_NUMBER_OF_COMPONENTS);
        if (numberOfComponents < 0) {
            numberOfComponents = exampleSet.getAttributes().size();
        }
        int numberOfIterations = this.getParameterAsInt(PARAMETER_NUMBER_OF_ITERATIONS);
        double[][] randomMatrix = new double[numberOfComponents][exampleSet.getAttributes().size()];
        for (int i = 0; i < randomMatrix.length; ++i) {
            for (int j = 0; j < randomMatrix[i].length; ++j) {
                randomMatrix[i][j] = random.nextDouble();
            }
        }
        Matrix W = new Matrix(randomMatrix);
        W.timesEquals(0.1);
        this.log("Training with learning rate: " + learningRate);
        this.train(data, W, numberOfIterations, learningRate, random);
        this.log("Creating the model...");
        Matrix covarianceMatrix = CovarianceMatrix.getCovarianceMatrix(exampleSet);
        Matrix tmp = W.times(covarianceMatrix);
        double[][] weights = W.getArray();
        double[][] tmparray = tmp.getArray();
        double[] eigenvalues = new double[numberOfComponents];
        for (int i = 0; i < weights.length; ++i) {
            double nr = 0.0;
            eigenvalues[i] = 0.0;
            for (int j = 0; j < weights[0].length; ++j) {
                tmparray[i][j] = tmparray[i][j] / weights[i][j];
                if (!(tmparray[i][j] > 0.0)) continue;
                nr += 1.0;
                int n = i;
                eigenvalues[n] = eigenvalues[n] + tmparray[i][j];
            }
            nr = Math.max(nr, 1.0);
            eigenvalues[i] = eigenvalues[i] / nr;
        }
        GHAModel model = new GHAModel(exampleSet, eigenvalues, W.getArray(), means);
        if (this.exampleSetOutput.isConnected()) {
            this.exampleSetOutput.deliver(model.apply((ExampleSet)exampleSet.clone()));
        }
        this.originalOutput.deliver(exampleSet);
        this.modelOutput.deliver(model);
    }

    private void train(double[][] data, Matrix W, int numberOfIterations, double learningRate, Random random) throws OperatorException {
        int iterlog = 1;
        while (numberOfIterations / iterlog > 10 && numberOfIterations / (iterlog * 10) >= 3) {
            iterlog *= 10;
        }
        for (int iter = 1; iter <= numberOfIterations; ++iter) {
            if (iter % iterlog == 0) {
                this.log("Iteration " + iter);
            }
            int sample = (int)(random.nextDouble() * (double)data.length);
            Matrix x = new Matrix(data[sample], data[sample].length);
            Matrix y = W.times(x);
            double[][] yyT = y.times(y.transpose()).getArray();
            for (int row = 0; row < yyT.length; ++row) {
                for (int col = row + 1; col < yyT.length; ++col) {
                    yyT[row][col] = 0.0;
                }
            }
            Matrix LT = new Matrix(yyT);
            Matrix tmp1 = y.times(x.transpose());
            Matrix tmp2 = LT.times(W);
            tmp1 = tmp1.minus(tmp2);
            tmp1.timesEquals(learningRate);
            W.plusEquals(tmp1);
            double[][] w = W.getArray();
            for (int i = 0; i < w.length; ++i) {
                for (int j = 0; j < w[0].length; ++j) {
                    if (!Double.isInfinite(w[i][j]) && !Double.isNaN(w[i][j])) continue;
                    throw new OperatorException("Lost convergence at iterator " + (iter + 1) + ". Lower learning rate?");
                }
            }
            this.checkForStop();
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_NUMBER_OF_COMPONENTS, "Number of components to compute. If '-1' nr of attributes is taken.'", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_ITERATIONS, "Number of Iterations to apply the update rule.", 0, Integer.MAX_VALUE, 10);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_LEARNING_RATE, "The learning rate for GHA (small)", 0.0, Double.POSITIVE_INFINITY, 0.01);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

