/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.features.transformation.AbstractFeatureTransformation;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.OperatorInsertionQuickFix;
import com.rapidminer.operator.preprocessing.filter.MissingValueReplenishment;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.math.Complex;
import com.rapidminer.tools.math.FastFourierTransform;
import com.rapidminer.tools.math.Peak;
import com.rapidminer.tools.math.SpectrumFilter;
import com.rapidminer.tools.math.container.Range;
import java.util.Collections;
import java.util.LinkedList;

public class FourierTransform
extends AbstractFeatureTransformation {
    public FourierTransform(OperatorDescription description) {
        super(description);
    }

    @Override
    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        for (AttributeMetaData amd : metaData.getAllAttributes()) {
            if (amd.isSpecial() || amd.containsMissingValues() != MetaDataInfo.YES) continue;
            this.getExampleSetInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), Collections.singletonList(new OperatorInsertionQuickFix("insert_missing_value_replenishment", new String[0], 1, this.getExampleSetInputPort()){

                @Override
                public Operator createOperator() throws OperatorCreationException {
                    return OperatorService.createOperator(MissingValueReplenishment.class);
                }
            }), "exampleset.contains_missings", this.getName()));
            break;
        }
        LinkedList<AttributeMetaData> newAttributes = new LinkedList<AttributeMetaData>();
        for (AttributeMetaData amd : metaData.getAllAttributes()) {
            if (amd.isSpecial() || !amd.isNumerical()) continue;
            AttributeMetaData newAttribute = new AttributeMetaData("fft(" + amd.getName() + ")", 4);
            newAttribute.setValueRange(new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), SetRelation.UNKNOWN);
            newAttributes.add(newAttribute);
        }
        metaData.clearRegular();
        metaData.clear();
        AttributeMetaData frequency = new AttributeMetaData("frequency", 4);
        metaData.addAttribute(frequency);
        metaData.addAllAttributes(newAttributes);
        if (metaData.getNumberOfExamples().isKnown()) {
            metaData.setNumberOfExamples(FastFourierTransform.getGreatestPowerOf2LessThan((Integer)metaData.getNumberOfExamples().getValue()) / 2);
        }
        return metaData;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNonMissingValues(exampleSet, "Fourier Transform");
        int numberOfNewExamples = FastFourierTransform.getGreatestPowerOf2LessThan(exampleSet.size()) / 2;
        MemoryExampleTable exampleTable = new MemoryExampleTable(new LinkedList<Attribute>(), new DataRowFactory(0, '.'), numberOfNewExamples);
        Attribute frequencyAttribute = AttributeFactory.createAttribute("frequency", 4);
        exampleTable.addAttribute(frequencyAttribute);
        DataRowReader drr = exampleTable.getDataRowReader();
        int k = 0;
        while (drr.hasNext()) {
            DataRow dataRow = (DataRow)drr.next();
            dataRow.set(frequencyAttribute, FastFourierTransform.convertFrequency(k++, numberOfNewExamples, exampleSet.size()));
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        attributes.add(frequencyAttribute);
        Attribute label = exampleSet.getAttributes().getLabel();
        FastFourierTransform fft = new FastFourierTransform(4);
        SpectrumFilter filter = new SpectrumFilter(0);
        for (Attribute current : exampleSet.getAttributes()) {
            if (!current.isNumerical()) continue;
            Complex[] result = fft.getFourierTransform(exampleSet, label, current);
            Peak[] spectrum = filter.filter(result, exampleSet.size());
            Attribute newAttribute = AttributeFactory.createAttribute("fft(" + current.getName() + ")", 4);
            exampleTable.addAttribute(newAttribute);
            attributes.add(newAttribute);
            this.fillTable(exampleTable, newAttribute, spectrum);
        }
        SimpleExampleSet resultSet = new SimpleExampleSet(exampleTable);
        return resultSet;
    }

    private void fillTable(ExampleTable table, Attribute attribute, Peak[] values) throws OperatorException {
        DataRowReader reader = table.getDataRowReader();
        int k = 0;
        while (reader.hasNext()) {
            DataRow dataRow = (DataRow)reader.next();
            dataRow.set(attribute, values[k++].getMagnitude());
            this.checkForStop();
        }
    }

    @Override
    public boolean writesIntoExistingData() {
        return false;
    }
}

