/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.ComponentWeightsCreatable;
import java.util.Iterator;

public class FastICAModel
extends AbstractModel
implements ComponentWeightsCreatable {
    private static final long serialVersionUID = -6380202686511014212L;
    private double[] means;
    private boolean rowNorm;
    private int numberOfComponents;
    private Matrix kMatrix;
    private Matrix wMatrix;
    private Matrix aMatrix;
    private String[] attributeNames;
    private int numberOfSamples;
    private int numberOfAttributes;
    private boolean keepAttributes = false;

    public FastICAModel(ExampleSet exampleSet, int numberOfComponents, double[] means, boolean rowNorm, Matrix kMatrix, Matrix wMatrix, Matrix aMatrix) {
        super(exampleSet);
        this.attributeNames = Tools.getRegularAttributeNames(exampleSet);
        this.numberOfComponents = numberOfComponents;
        this.means = means;
        this.rowNorm = rowNorm;
        this.kMatrix = kMatrix;
        this.wMatrix = wMatrix;
        this.aMatrix = aMatrix;
    }

    @Override
    public ExampleSet apply(ExampleSet testSet) throws OperatorException {
        Example example;
        testSet.recalculateAllAttributeStatistics();
        this.numberOfSamples = testSet.size();
        this.numberOfAttributes = testSet.getAttributes().size();
        if (this.numberOfAttributes != this.means.length) {
            throw new UserError(null, 133, this.means.length, this.numberOfAttributes);
        }
        for (Attribute attribute : testSet.getAttributes()) {
            if (attribute.isNumerical()) continue;
            throw new UserError(null, 104, "FastICA", attribute.getName());
        }
        double[][] data = new double[this.numberOfSamples][this.numberOfAttributes];
        Iterator reader = testSet.iterator();
        for (int sample = 0; sample < this.numberOfSamples; ++sample) {
            example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : testSet.getAttributes()) {
                data[sample][d] = example.getValue(attribute) - this.means[d];
                ++d;
            }
        }
        if (this.rowNorm) {
            this.log("Scaling the data now.");
            for (int row = 0; row < this.numberOfSamples; ++row) {
                int d;
                double rmsRow = 0.0;
                for (d = 0; d < this.numberOfAttributes; ++d) {
                    rmsRow += data[row][d] * data[row][d];
                }
                rmsRow = Math.sqrt(rmsRow) / (double)Math.max(1, this.numberOfAttributes - 1);
                for (d = 0; d < this.numberOfAttributes; ++d) {
                    data[row][d] = data[row][d] / rmsRow;
                }
            }
        }
        Matrix X = new Matrix(data);
        Matrix S = X.times(this.kMatrix).times(this.wMatrix);
        if (!this.keepAttributes) {
            testSet.getAttributes().clearRegular();
        }
        Attribute[] icAttributes = new Attribute[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            icAttributes[i] = AttributeFactory.createAttribute("ic_" + (i + 1), 4);
            testSet.getExampleTable().addAttribute(icAttributes[i]);
            testSet.getAttributes().addRegular(icAttributes[i]);
        }
        double[][] finaldata = S.getArray();
        reader = testSet.iterator();
        for (int sample = 0; sample < testSet.size(); ++sample) {
            example = (Example)reader.next();
            for (int d = 0; d < this.numberOfComponents; ++d) {
                example.setValue(icAttributes[d], finaldata[sample][d]);
            }
        }
        return testSet;
    }

    public void setNumberOfComponents(int number) {
        this.numberOfComponents = number;
    }

    @Override
    public void setParameter(String name, Object object) throws OperatorException {
        if (name.equals("number_of_components")) {
            String value = (String)object;
            try {
                this.setNumberOfComponents(Integer.parseInt(value));
            }
            catch (NumberFormatException error) {
                super.setParameter(name, value);
            }
        } else if (name.equals("keep_attributes")) {
            String value = (String)object;
            this.keepAttributes = false;
            if (value.equals("true")) {
                this.keepAttributes = true;
            }
        } else {
            super.setParameter(name, object);
        }
    }

    @Override
    public AttributeWeights getWeightsOfComponent(int component) throws OperatorException {
        if (component < 1) {
            component = 1;
        }
        if (component > this.numberOfComponents) {
            this.logWarning("Creating weights of component " + this.numberOfComponents + "!");
            component = this.numberOfComponents;
        }
        AttributeWeights attweights = new AttributeWeights();
        for (int i = 0; i < this.attributeNames.length; ++i) {
            attweights.setWeight(this.attributeNames[i], this.aMatrix.get(component - 1, i));
        }
        return attweights;
    }

    @Override
    public String toResultString() {
        StringBuffer result = new StringBuffer();
        result.append("Number of Components: " + this.numberOfComponents + com.rapidminer.tools.Tools.getLineSeparator());
        if (this.aMatrix != null) {
            result.append("Resulting attribute weights (from first component):" + com.rapidminer.tools.Tools.getLineSeparator());
            for (int i = 0; i < this.attributeNames.length; ++i) {
                result.append(this.attributeNames[i] + ": " + com.rapidminer.tools.Tools.formatNumber(this.aMatrix.get(0, i)) + com.rapidminer.tools.Tools.getLineSeparator());
            }
        }
        return result.toString();
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("ICA Model" + com.rapidminer.tools.Tools.getLineSeparator());
        result.append("Number of Components: " + this.numberOfComponents + com.rapidminer.tools.Tools.getLineSeparator());
        return result.toString();
    }
}

