/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.FastICAModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.MathFunctions;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class FastICA
extends Operator {
    public static final String PARAMETER_NUMBER_OF_COMPONENTS = "number_of_components";
    public static final String PARAMETER_ALGORITHM_TYPE = "algorithm_type";
    public static final String PARAMETER_FUNCTION = "function";
    public static final String PARAMETER_ALPHA = "alpha";
    public static final String PARAMETER_ROW_NORM = "row_norm";
    public static final String PARAMETER_MAX_ITERATION = "max_iteration";
    public static final String PARAMETER_TOLERANCE = "tolerance";
    public static final String PARAMETER_REDUCTION_TYPE = "dimensionality_reduction";
    public static final String[] REDUCTION_METHODS = new String[]{"none", "fixed number"};
    public static final int REDUCTION_NONE = 0;
    public static final int REDUCTION_FIXED = 1;
    private static final String[] ALGORITHM_TYPE = new String[]{"deflation", "parallel"};
    private static final String[] FUNCTION = new String[]{"logcosh", "exp"};
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private OutputPort originalOutput = (OutputPort)this.getOutputPorts().createPort("original");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("preprocessing model");

    public FastICA(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 2, new String[0]){

            @Override
            public void makeAdditionalChecks(ExampleSetMetaData emd) throws UndefinedParameterError {
                int desiredComponents = FastICA.this.getParameterAsInt(FastICA.PARAMETER_NUMBER_OF_COMPONENTS);
                if (desiredComponents > emd.getNumberOfRegularAttributes() && FastICA.this.getParameterAsInt(FastICA.PARAMETER_REDUCTION_TYPE) == 1 && emd.getAttributeSetRelation() != SetRelation.UNKNOWN) {
                    ProcessSetupError.Severity sev = ProcessSetupError.Severity.ERROR;
                    if (emd.getAttributeSetRelation() == SetRelation.SUPERSET) {
                        sev = ProcessSetupError.Severity.WARNING;
                    }
                    FastICA.this.exampleSetInput.addError(new SimpleMetaDataError(sev, (Port)FastICA.this.exampleSetInput, Collections.singletonList(new ParameterSettingQuickFix(FastICA.this, FastICA.PARAMETER_NUMBER_OF_COMPONENTS, emd.getNumberOfRegularAttributes() + "")), "exampleset.parameters.need_more_attributes", desiredComponents, FastICA.PARAMETER_NUMBER_OF_COMPONENTS, desiredComponents));
                }
                super.makeAdditionalChecks(emd);
            }
        });
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.originalOutput, SetRelation.EQUAL));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.SUBSET){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
                int numberOfAttributes = 0;
                Iterator<AttributeMetaData> iterator = metaData.getAllAttributes().iterator();
                while (iterator.hasNext()) {
                    AttributeMetaData current = iterator.next();
                    if (current.isSpecial()) continue;
                    iterator.remove();
                    ++numberOfAttributes;
                }
                try {
                    int numberOfGeneratedAttributes = FastICA.this.getParameterAsInt(FastICA.PARAMETER_REDUCTION_TYPE) == 1 ? FastICA.this.getParameterAsInt(FastICA.PARAMETER_NUMBER_OF_COMPONENTS) : numberOfAttributes;
                    for (int i = 1; i <= numberOfGeneratedAttributes; ++i) {
                        AttributeMetaData generatedAttribute = new AttributeMetaData("ic_" + i, 2);
                        metaData.addAttribute(generatedAttribute);
                    }
                    metaData.attributesAreKnown();
                    return metaData;
                }
                catch (UndefinedParameterError e) {
                    return metaData;
                }
            }
        });
        this.getTransformer().addRule(new GenerateNewMDRule(this.modelOutput, Model.class));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData();
        set.recalculateAllAttributeStatistics();
        int numberOfSamples = set.size();
        int numberOfAttributes = set.getAttributes().size();
        Attribute[] attributes = new Attribute[numberOfAttributes];
        double[] means = new double[numberOfAttributes];
        int i = 0;
        Iterator<Attribute> atts = set.getAttributes().iterator();
        while (atts.hasNext()) {
            attributes[i] = atts.next();
            if (!attributes[i].isNumerical()) {
                throw new UserError((Operator)this, 104, "FastICA", attributes[i].getName());
            }
            means[i] = set.getStatistics(attributes[i], "average");
            ++i;
        }
        int algorithmType = this.getParameterAsInt(PARAMETER_ALGORITHM_TYPE);
        int function = this.getParameterAsInt(PARAMETER_FUNCTION);
        double tolerance = this.getParameterAsDouble(PARAMETER_TOLERANCE);
        double alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        boolean rowNorm = this.getParameterAsBoolean(PARAMETER_ROW_NORM);
        int maxIteration = this.getParameterAsInt(PARAMETER_MAX_ITERATION);
        int numberOfComponents = this.getParameterAsInt(PARAMETER_REDUCTION_TYPE) == 1 ? this.getParameterAsInt(PARAMETER_NUMBER_OF_COMPONENTS) : numberOfAttributes;
        if (numberOfComponents > numberOfAttributes) {
            numberOfComponents = numberOfAttributes;
            this.getLogger().log(Level.WARNING, "The parameter 'number_of_components' is too large! Set to number of attributes.");
        }
        double[][] data = new double[numberOfSamples][numberOfAttributes];
        Iterator reader = set.iterator();
        for (int sample = 0; sample < numberOfSamples; ++sample) {
            Example example = (Example)reader.next();
            for (int d = 0; d < numberOfAttributes; ++d) {
                data[sample][d] = example.getValue(attributes[d]) - means[d];
            }
        }
        double[][] wInit = new double[numberOfComponents][numberOfComponents];
        RandomGenerator randomGenerator = RandomGenerator.getRandomGenerator(this);
        for (i = 0; i < numberOfComponents; ++i) {
            for (int j = 0; j < numberOfComponents; ++j) {
                wInit[i][j] = randomGenerator.nextDouble() * 2.0 - 1.0;
            }
        }
        if (rowNorm) {
            for (int row = 0; row < numberOfSamples; ++row) {
                int d;
                double rms_row = 0.0;
                for (d = 0; d < numberOfAttributes; ++d) {
                    rms_row += data[row][d] * data[row][d];
                }
                rms_row = Math.sqrt(rms_row) / (double)Math.max(1, numberOfAttributes - 1);
                for (d = 0; d < numberOfAttributes; ++d) {
                    data[row][d] = data[row][d] / rms_row;
                }
            }
        }
        Matrix xMatrix = new Matrix(data).transpose();
        SingularValueDecomposition svd = xMatrix.times(xMatrix.transpose().timesEquals(1.0 / (double)numberOfSamples)).svd();
        Matrix dMatrix = svd.getS();
        double[][] singularvalue = dMatrix.getArray();
        for (i = 0; i < singularvalue.length; ++i) {
            singularvalue[i][i] = 1.0 / Math.sqrt(singularvalue[i][i]);
        }
        dMatrix = new Matrix(singularvalue);
        Matrix kMatrix = dMatrix.times(svd.getU().transpose());
        kMatrix = new Matrix(kMatrix.getArray(), numberOfComponents, numberOfAttributes);
        Matrix a = algorithmType == 0 ? this.deflation(kMatrix.times(xMatrix), wInit, tolerance, alpha, numberOfSamples, numberOfComponents, function, maxIteration) : this.parallel(kMatrix.times(xMatrix), wInit, tolerance, alpha, numberOfSamples, numberOfComponents, function, maxIteration);
        Matrix w = a.times(kMatrix);
        kMatrix = kMatrix.transpose();
        Matrix wMatrix = a.transpose();
        Matrix aMatrix = w.transpose().times(w.times(w.transpose()).inverse()).transpose();
        FastICAModel model = new FastICAModel(set, numberOfComponents, means, rowNorm, kMatrix, wMatrix, aMatrix);
        if (this.exampleSetOutput.isConnected()) {
            this.exampleSetOutput.deliver(model.apply((ExampleSet)set.clone()));
        }
        this.originalOutput.deliver(set);
        this.modelOutput.deliver(model);
    }

    private Matrix deflation(Matrix X, double[][] wInit, double tolerance, double alpha, int numberOfSamples, int numberOfComponents, int function, int maxIteration) throws OperatorException {
        Matrix W = new Matrix(numberOfComponents, numberOfComponents, 0.0);
        int iterlog = 1;
        while (maxIteration / iterlog > 10 && maxIteration / (iterlog * 10) >= 3) {
            iterlog *= 10;
        }
        for (int i = 0; i < numberOfComponents; ++i) {
            double k;
            Matrix Wu;
            Matrix t;
            Matrix w = new Matrix(wInit[i], wInit[i].length);
            if (i > 0) {
                t = new Matrix(wInit[i].length, 1, 0.0);
                for (int u = 1; u <= i; ++u) {
                    Wu = W.getMatrix(u - 1, u - 1, 0, numberOfComponents - 1);
                    k = w.transpose().times(Wu.transpose()).getArray()[0][0];
                    t.plusEquals(Wu.times(k).transpose());
                }
                w.minusEquals(t);
            }
            double rss = Math.sqrt(w.times(w.transpose()).getArray()[0][0]);
            w.timesEquals(1.0 / rss);
            double lim = 1000.0;
            for (int iter = 1; lim > tolerance && iter <= maxIteration; ++iter) {
                double value;
                int j;
                int j2;
                Matrix wx = w.transpose().times(X);
                double[][] wxarray = wx.getArray();
                if (function == 0) {
                    for (j2 = 0; j2 < wxarray[0].length; ++j2) {
                        wxarray[0][j2] = MathFunctions.tanh(alpha * wxarray[0][j2]);
                    }
                } else {
                    for (j2 = 0; j2 < wxarray[0].length; ++j2) {
                        wxarray[0][j2] = wxarray[0][j2] * Math.exp(-0.5 * wxarray[0][j2] * wxarray[0][j2]);
                    }
                }
                Matrix gwx = new Matrix(wxarray);
                double[][] gwxarray = gwx.getArray();
                double[][] Xarray = X.getArray();
                for (int row = 0; row < Xarray.length; ++row) {
                    for (int col = 0; col < Xarray[0].length; ++col) {
                        Xarray[row][col] = Xarray[row][col] * gwxarray[0][col];
                    }
                }
                Matrix xgwx = new Matrix(Xarray);
                Matrix v1 = new Matrix(numberOfComponents, 1, 0.0);
                for (int row = 0; row < numberOfComponents; ++row) {
                    double mean = 0.0;
                    for (int col = 0; col < numberOfSamples; ++col) {
                        mean += xgwx.get(row, col);
                    }
                    v1.set(row, 0, mean /= (double)numberOfSamples);
                }
                Matrix g_wx = wx.copy();
                double mean = 0.0;
                if (function == 0) {
                    for (j = 0; j < wxarray[0].length; ++j) {
                        value = MathFunctions.tanh(alpha * g_wx.get(0, j));
                        value = alpha * (1.0 - value * value);
                        mean += value;
                        g_wx.set(0, j, value);
                    }
                } else {
                    for (j = 0; j < wxarray[0].length; ++j) {
                        value = g_wx.get(0, j);
                        value = (1.0 - value * value) * Math.exp(-0.5 * value * value);
                        mean += value;
                        g_wx.set(0, j, value);
                    }
                }
                Matrix v2 = w.copy();
                v2.timesEquals(mean /= (double)numberOfSamples);
                Matrix w1 = v1.minus(v2);
                if (i > 0) {
                    t = new Matrix(w1.getRowDimension(), w1.getColumnDimension(), 0.0);
                    for (int u = 1; u <= i; ++u) {
                        Wu = W.getMatrix(u - 1, u - 1, 0, numberOfComponents - 1);
                        k = w1.transpose().times(Wu.transpose()).getArray()[0][0];
                        t.plusEquals(Wu.times(k).transpose());
                    }
                    w1.minusEquals(t);
                }
                rss = Math.sqrt(w1.transpose().times(w1).getArray()[0][0]);
                w1.timesEquals(1.0 / rss);
                lim = Math.abs(Math.abs(w1.transpose().times(w).getArray()[0][0]) - 1.0);
                if (iter % iterlog == 0 || lim <= tolerance) {
                    this.log("Iteration " + iter + ", tolerance = " + lim);
                }
                w = w1.copy();
            }
            for (int col = 0; col < numberOfComponents; ++col) {
                W.set(i, col, w.get(col, 0));
            }
            this.checkForStop();
        }
        return W;
    }

    private Matrix parallel(Matrix X, double[][] wInit, double tolerance, double alpha, int numberOfSamples, int numberOfComponents, int function, int maxIteration) throws OperatorException {
        int p = X.getColumnDimension();
        Matrix W = new Matrix(wInit);
        SingularValueDecomposition svd = W.svd();
        double[] svalues = svd.getSingularValues();
        Matrix svaluesMatrix = new Matrix(svalues.length, svalues.length, 0.0);
        for (int i = 0; i < svalues.length; ++i) {
            svalues[i] = 1.0 / svalues[i];
            svaluesMatrix.set(i, i, svalues[i]);
        }
        W = svd.getU().times(svaluesMatrix).times(svd.getU().transpose()).times(W);
        Matrix W1 = W.copy();
        double lim = 1000.0;
        int iter = 1;
        int iterlog = 1;
        while (maxIteration / iterlog > 10 && maxIteration / (iterlog * 10) >= 3) {
            iterlog *= 10;
        }
        while (lim > tolerance && iter <= maxIteration) {
            double mean;
            double value;
            int col;
            int row;
            Matrix wx = W.times(X);
            Matrix gwx = wx.copy();
            if (function == 0) {
                for (row = 0; row < numberOfComponents; ++row) {
                    for (col = 0; col < numberOfSamples; ++col) {
                        value = gwx.get(row, col);
                        value = MathFunctions.tanh(alpha * value);
                        gwx.set(row, col, value);
                    }
                }
            } else {
                for (row = 0; row < numberOfComponents; ++row) {
                    for (col = 0; col < numberOfSamples; ++col) {
                        value = gwx.get(row, col);
                        value *= Math.exp(-0.5 * value * value);
                        gwx.set(row, col, value);
                    }
                }
            }
            Matrix v1 = gwx.times(X.transpose()).times((double)p);
            Matrix g_wx = gwx.copy();
            Matrix diagmean = new Matrix(numberOfComponents, numberOfComponents, 0.0);
            if (function == 0) {
                for (row = 0; row < numberOfComponents; ++row) {
                    mean = 0.0;
                    for (col = 0; col < numberOfSamples; ++col) {
                        value = g_wx.get(row, col);
                        value = alpha * (1.0 - value * value);
                        g_wx.set(row, col, value);
                        mean += value;
                    }
                    diagmean.set(row, row, mean /= (double)numberOfSamples);
                }
            } else {
                g_wx = wx.copy();
                for (row = 0; row < numberOfComponents; ++row) {
                    mean = 0.0;
                    for (col = 0; col < numberOfSamples; ++col) {
                        value = g_wx.get(row, col);
                        value = (1.0 - value * value) * Math.exp(-0.5 * value * value);
                        g_wx.set(row, col, value);
                        mean += value;
                    }
                    diagmean.set(row, row, mean /= (double)numberOfSamples);
                }
            }
            Matrix v2 = diagmean.times(W);
            W1 = v1.minus(v2);
            svd = W1.svd();
            svalues = svd.getSingularValues();
            svaluesMatrix = new Matrix(svalues.length, svalues.length, 0.0);
            for (int i = 0; i < svalues.length; ++i) {
                svalues[i] = 1.0 / svalues[i];
                svaluesMatrix.set(i, i, svalues[i]);
            }
            W1 = svd.getU().times(svaluesMatrix).times(svd.getU().transpose()).times(W1);
            double[][] diag = W1.times(W.transpose()).getArray();
            value = Double.NEGATIVE_INFINITY;
            for (int row2 = 0; row2 < numberOfComponents; ++row2) {
                value = Math.max(value, Math.abs(Math.abs(diag[row2][row2]) - 1.0));
            }
            lim = value;
            W = W1.copy();
            if (iter % iterlog == 0 || lim <= tolerance) {
                this.log("Iteration " + iter + ", tolerance = " + lim);
            }
            ++iter;
        }
        return W;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_REDUCTION_TYPE, "Indicates which type of dimensionality reduction should be applied", REDUCTION_METHODS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_COMPONENTS, "Keep this number of components.", 1, Integer.MAX_VALUE);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_REDUCTION_TYPE, REDUCTION_METHODS, true, 1));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_ALGORITHM_TYPE, "If 'parallel' the components are extracted simultaneously, 'deflation' the components are extracted one at a time", ALGORITHM_TYPE, 0);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_FUNCTION, "The functional form of the G function used in the approximation to neg-entropy", FUNCTION, 0);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_ALPHA, "constant in range [1, 2] used in approximation to neg-entropy when fun=\"logcosh\"", 1.0, 2.0, 1.0);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_ROW_NORM, "Indicates whether rows of the data matrix should be standardized beforehand.", false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_ITERATION, "maximum number of iterations to perform", 0, Integer.MAX_VALUE, 200);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_TOLERANCE, "A positive scalar giving the tolerance at which the un-mixing matrix is considered to have converged.", 0.0, Double.POSITIVE_INFINITY, 1.0E-4);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

