/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.OperatorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DimensionalityReducerModel
extends AbstractModel {
    private static final long serialVersionUID = 1036161585615738268L;
    private int dimensions;
    private double[][] p;

    protected DimensionalityReducerModel(ExampleSet exampleSet, double[][] p, int dimensions) {
        super(exampleSet);
        this.p = p;
        this.dimensions = dimensions;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < this.dimensions; ++i) {
            Attribute att = AttributeFactory.createAttribute("d" + i, 4);
            attributes.add(att);
        }
        HashMap<String, Attribute> newSpecialAttributes = new HashMap<String, Attribute>();
        HashMap<String, Attribute> oldSpecialAttributes = new HashMap<String, Attribute>();
        Iterator<AttributeRole> s = exampleSet.getAttributes().specialAttributes();
        while (s.hasNext()) {
            AttributeRole role = s.next();
            Attribute att = AttributeFactory.createAttribute(role.getAttribute());
            newSpecialAttributes.put(role.getSpecialName(), att);
            oldSpecialAttributes.put(role.getSpecialName(), role.getAttribute());
            attributes.add(att);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        int i = 0;
        for (Example oldExample : exampleSet) {
            DoubleArrayDataRow row = new DoubleArrayDataRow(new double[attributes.size()]);
            for (int j = 0; j < this.dimensions; ++j) {
                row.set((Attribute)attributes.get(j), this.p[i][j]);
            }
            for (String specialAttributeRole : newSpecialAttributes.keySet()) {
                Attribute attribute = (Attribute)newSpecialAttributes.get(specialAttributeRole);
                row.set(attribute, oldExample.getValue((Attribute)oldSpecialAttributes.get(specialAttributeRole)));
            }
            table.addDataRow(row);
            ++i;
        }
        ExampleSet resultSet = table.createExampleSet();
        Attributes newAttributes = resultSet.getAttributes();
        for (Map.Entry specialEntry : newSpecialAttributes.entrySet()) {
            newAttributes.setSpecialAttribute((Attribute)specialEntry.getValue(), (String)specialEntry.getKey());
        }
        return resultSet;
    }

    @Override
    public String getName() {
        return "Dimensionality Reduction";
    }

    @Override
    public String toString() {
        return "This model reduces the number of dimensions to " + this.dimensions + ".";
    }
}

