/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.transformation.DimensionalityReducerModel;
import com.rapidminer.operator.learner.CapabilityProvider;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.CapabilityPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

public abstract class DimensionalityReducer
extends Operator
implements CapabilityProvider {
    public static final String PARAMETER_DIMENSIONS = "dimensions";
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private OutputPort originalOutput = (OutputPort)this.getOutputPorts().createPort("original");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("preprocessing model");

    public DimensionalityReducer(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new CapabilityPrecondition(this, this.exampleSetInput));
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.SUBSET){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                metaData.clearRegular();
                int numberOfDimensinos = DimensionalityReducer.this.getParameterAsInt(DimensionalityReducer.PARAMETER_DIMENSIONS);
                for (int i = 0; i < numberOfDimensinos; ++i) {
                    metaData.addAttribute(new AttributeMetaData("d" + i, 4));
                }
                return metaData;
            }
        });
        this.getTransformer().addRule(new GenerateNewMDRule(this.modelOutput, Model.class));
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.originalOutput, false));
    }

    protected abstract double[][] dimensionalityReduction(ExampleSet var1, int var2);

    @Override
    public void doWork() throws OperatorException {
        ExampleSet es = (ExampleSet)this.exampleSetInput.getData();
        int dimensions = this.getParameterAsInt(PARAMETER_DIMENSIONS);
        Tools.onlyNumericalAttributes(es, "dimensionality reduction");
        Tools.isNonEmpty(es);
        Tools.checkAndCreateIds(es);
        double[][] p = this.dimensionalityReduction(es, dimensions);
        DimensionalityReducerModel model = new DimensionalityReducerModel(es, p, dimensions);
        if (this.exampleSetOutput.isConnected()) {
            this.exampleSetOutput.deliver(model.apply((ExampleSet)es.clone()));
        }
        this.originalOutput.deliver(es);
        this.modelOutput.deliver(model);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("return_preprocessing_model", "Indicates if the preprocessing model should also be returned", false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_DIMENSIONS, "the number of dimensions in the result representation", 1, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

