/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.selection.IterativeFeatureAdding;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.LinkedList;
import java.util.List;

public class WeightGuidedSelectionOperator
extends FeatureOperator {
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_USE_ABSOLUTE_WEIGHTS = "use_absolute_weights";
    public static final String PARAMETER_USE_EARLY_STOPPING = "use_early_stopping";
    private int generationsWOImp;
    private int maxGenerations;
    private int maxWeightIndex = -1;
    private InputPort attributeWeightsInput = this.getInputPorts().createPort("attribute weights in", AttributeWeights.class);

    public WeightGuidedSelectionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected ExampleSetMetaData modifyInnerOutputExampleSet(ExampleSetMetaData metaData) {
        metaData.attributesAreSubset();
        return metaData;
    }

    @Override
    protected ExampleSetMetaData modifyOutputExampleSet(ExampleSetMetaData metaData) {
        metaData.attributesAreSubset();
        return metaData;
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        this.generationsWOImp = this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL);
        this.maxGenerations = es.getAttributes().size();
        Population initP = new Population();
        double[] weights = new double[es.getAttributes().size()];
        if (this.maxWeightIndex >= 0) {
            weights[this.maxWeightIndex] = 1.0;
        } else {
            weights[0] = 1.0;
        }
        initP.add(new Individual(weights));
        return initP;
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        String[] attributeNames = Tools.getRegularAttributeNames(input);
        AttributeWeights attributeWeights = (AttributeWeights)this.attributeWeightsInput.getData();
        attributeWeights.sortByWeight(attributeNames, 1, this.getParameterAsBoolean(PARAMETER_USE_ABSOLUTE_WEIGHTS) ? 1 : 0);
        int[] attributeIndices = new int[input.getAttributes().size()];
        int counter = 0;
        for (String name : attributeNames) {
            int index = 0;
            for (Attribute attribute : input.getAttributes()) {
                if (attribute.getName().equals(name)) {
                    attributeIndices[counter] = index;
                    break;
                }
                ++index;
            }
            ++counter;
        }
        this.maxWeightIndex = attributeIndices[0];
        preOp.add(new IterativeFeatureAdding(attributeIndices, 1));
        return preOp;
    }

    @Override
    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public boolean solutionGoodEnough(Population pop) throws OperatorException {
        return pop.empty() || this.generationsWOImp > 0 && pop.getGenerationsWithoutImproval() >= this.generationsWOImp || pop.getGeneration() >= this.maxGenerations;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeBoolean(PARAMETER_USE_EARLY_STOPPING, "Enables early stopping. If unchecked, always the maximum number of generations is performed.", false));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop criterion: Stop after n generations without improval of the performance.", 1, Integer.MAX_VALUE, 2);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_EARLY_STOPPING, true, true));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ABSOLUTE_WEIGHTS, "Indicates that the absolute values of the input weights should be used to determine the feature adding order.", true));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

