/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.IndividualOperator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class SelectionMutation
extends IndividualOperator {
    private double probability;
    private Random random;
    private int minNumber;
    private int maxNumber;
    private int exactNumber;

    public SelectionMutation(double probability, Random random, int minNumber, int maxNumber, int exactNumber) {
        this.probability = probability;
        this.random = random;
        this.minNumber = minNumber;
        this.maxNumber = maxNumber;
        this.exactNumber = exactNumber;
    }

    @Override
    public List<Individual> operate(Individual individual) {
        LinkedList<Individual> l = new LinkedList<Individual>();
        double[] weights = individual.getWeightsClone();
        double prob = this.probability < 0.0 ? 1.0 / (double)weights.length : this.probability;
        for (int i = 0; i < weights.length; ++i) {
            if (!(this.random.nextDouble() < prob)) continue;
            weights[i] = weights[i] > 0.0 ? 0.0 : 1.0;
        }
        Individual newIndividual = new Individual(weights);
        int numberOfFeatures = newIndividual.getNumberOfUsedAttributes();
        if (numberOfFeatures > 0) {
            if (this.exactNumber > 0) {
                if (numberOfFeatures == this.exactNumber) {
                    l.add(newIndividual);
                }
            } else if ((this.maxNumber < 1 || numberOfFeatures <= this.maxNumber) && numberOfFeatures >= this.minNumber) {
                l.add(newIndividual);
            }
        }
        l.add(individual);
        return l;
    }
}

